/**
 * mCoreLite - Librairie mBot (mCore)
 * Auteur : Sébastien Tack - novembre 2025 (sebastien.tack@free.fr)
 *
 * E/S utilisées :
 *  Moteurs    : D7/D6 (M1) et D4/D5 (M2)
 *  Ligne      : D9 / D10
 *  LDR        : A6
 *  Bouton     : A7
 *  Buzzer     : D8
 *  LEDs       : D13 (WS2812)
 *  IR         : D2 (réception) / D3 (émission)
 *  Ultrason   : A3 (mono-fil TRIG/ECHO combinés – mBot v3)
 *  Bluetooth / Serial USB : D0 (RX), D1 (TX)
 *
 * Pins totalement libres :
 *  D11, D12,
 *  A0, A1,A2,
 *  A4, A5 (I2C) A ne pas utiliser sauf stricte nécessité
 *  --------------------------------------------------------------------------
 *  Notes :
 *    - La bibliothèque IRremote est utilisée pour le décodage NEC.
 *    - Le capteur ultrason est géré en mode “monofil” compatible mBot.
 *    - Les LED WS2812 utilisent Adafruit_NeoPixel.
 *  --------------------------------------------------------------------------
 */

#ifndef MCORELITE_H
#define MCORELITE_H

#include <Arduino.h>

#define M1_DIR 7
#define M1_PWM 6
#define M2_DIR 4
#define M2_PWM 5

#define LED_WS2812_PIN 13

#define BUTTON_PIN A7        // bouton correct
#define BUZZER_PIN 8         // buzzer correct

#define LINE_L 9             // digital
#define LINE_R 10            // digital

#define LDR_PIN A6           // capteur lumière correct
#define US_PIN A3
#define IR_RECEIVE_PIN 2
#define IR_EMITTER_PIN 3

class mCoreLite {
public:;
    bool useLineSensors = true;
    char car_send = 0;   // dernier caractère IR reçu
    bool flag = false;   // événement IR en attente
    char decodeMbot(uint8_t cmd);
	void enableLineSensors(bool enable);
    uint8_t IrReadCode();
    void botSetup();         // ✔ bon prototype sans préfixe
    void botSetupIr();         
	void motor(int id, int speed);
    void motors(int left, int right);
	void forward(int speed);
	void reverse(int speed);
	void left(int speed);
	void right(int speed);
	void stop();
    int button();
    int lineLeft();
    int lineRight();
    int light();
	long distanceCM();
    void toneBuz(int freq, int dur);
    void beginLED();
    void setLED(int id, uint8_t r, uint8_t g, uint8_t b);
	void pause(uint32_t ms);

};

#endif
