
#include "WiFiS3.h"
#include "arduino_secrets.h" 
///////please enter your sensitive data in the Secret tab/arduino_secrets.h
char ssid[] = SECRET_SSID;        // your network SSID (name)
char pass[] = SECRET_PASS;        // your network password (use for WPA, or use as key for WEP)
int keyIndex = 0;                 // your network key index number (needed only for WEP)
int status = WL_IDLE_STATUS;
WiFiServer server(80);
void setup_wifi() {
  //Initialize serial and wait for port to open:
  if (DEBUG) {
    Serial.begin(9600);
    while (!Serial) {
      ; // wait for serial port to connect. Needed for native USB port only
    }
    Serial.println("Access Point Web Server");
  }
  
  pinMode(led, OUTPUT);      // set the LED pin mode

  // check for the WiFi module:
  if (WiFi.status() == WL_NO_MODULE) {
    if (DEBUG) 
    {
      Serial.println("Communication with WiFi module failed!");
    }
    // don't continue
    while (true);
  }

  String fv = WiFi.firmwareVersion();
  if (fv < WIFI_FIRMWARE_LATEST_VERSION) {
    if (DEBUG) {
      Serial.println("Please upgrade the firmware");
    }
  }

  // by default the local IP address will be 192.168.4.1
  // you can override it with the following:
  WiFi.config(IPAddress(192,168,4,1));

  // print the network name (SSID);
  if (DEBUG) {
    Serial.print("Creating access point named: ");
    Serial.println(ssid);
  }
  // Create open network. Change this line if you want to create an WEP network:
  status = WiFi.beginAP(ssid, pass);
  if (status != WL_AP_LISTENING) {
    if (DEBUG) {
    Serial.println("Creating access point failed");
    }
    // don't continue
    while (true);
  }

  // wait 10 seconds for connection:
  delay(10000);

  // start the web server on port 80
  server.begin();

  // you're connected now, so print out the status
  if (DEBUG) {
    printWiFiStatus();
  }
}
void gere_serveur() {
  
   // list for incoming clients
  WiFiClient client = server.available();

  if (client) {
    if (DEBUG) {
      Serial.print("New client connected...");    
    }
    if (client.connected()) {
      int bytes = client.available();
      if (bytes > 0) {
        // read the whole http request 
        String request = "";    
        for (int i = 0; i < bytes; i++) {
          char c = client.read();
          request += c;
        }
        // print the http request
        if (DEBUG) {
          Serial.println(request);
        }        

        traite_wifi(request);

        // send response 
        client.println("HTTP/1.1 200 OK");
        client.println("Content-type:text/html");
        client.println();
      } 
    }

    // close the connection
    client.stop();
    if (DEBUG) { 
      Serial.println("Client disconnected");
    }
    delay(50);
  }
}

void printWiFiStatus() {
  // print the SSID of the network you're attached to:
  Serial.print("SSID: ");
  Serial.println(WiFi.SSID());

  // print your WiFi shield's IP address:
  IPAddress ip = WiFi.localIP();
  Serial.print("IP Address: ");
  Serial.println(ip);

  // print where to go in a browser:
  Serial.print("To see this page in action, open a browser to http://");
  Serial.println(ip);
}