void setup() {
  init_moteurs();
  Serial.begin(115200);
  Serial.println("Motor Control Ready. Enter F, B, L, R, S.");
}

void loop() {
  // Check if there is data available on the serial input
  if (Serial.available() > 0) {
    char command = Serial.read(); // Read the incoming command
    command = toupper(command);  // Ensure command is uppercase

    switch (command) {
      case 'F':
        // Move forward
        avancer(150);
        Serial.println("Moving Forward");
        break;

      case 'B':
        // Move backward
        reculer(150);
        Serial.println("Moving Backward");
        break;

      case 'L':
        // Turn left (stop one motor, run the other)
        gauche(150);
        Serial.println("Turning Left");
        break;

      case 'R':
        // Turn right (stop one motor, run the other)
        droite(150);
        Serial.println("Turning Right");
        break;

      case 'S':
        // Stop all motors
        stopMotors();
        Serial.println("Stopping Motors");
        break;

      default:
        // Handle invalid commands
        Serial.println("Invalid Command. Use F, B, L, R, S.");
        break;
    }
  }
}

