#include <Servo.h>
Servo myservo;  

bool suivi_piste = false;

// Capteurs de suivi de ligne

const int baseSpeed = 110;
const int turnSpeed  = 0;
const int capteurGauche = A4;
const int capteurDroit  = A5;

// Seuil de détection noir/blanc
const int seuil = 500;  // Ajustez si nécessaire


void setup()
{
  myservo.attach(6);  // attaches the servo on pin 6 to the servo object
  myservo.write(1500);
  delay(10);  
  myservo.detach();
  init_moteurs(); 
  Serial.begin(115200);
  setup_wifi();
}

void loop() {
  char c= read_udp();
  Serial.println(c);
  if (c == 'A') {
    avancer(baseSpeed);
  } 
  else if (c == 'R') {
    reculer(baseSpeed);
  }
  else if (c == 'G') {
    gauche(baseSpeed);
  }
  else if (c == 'D') {
    droite(baseSpeed);
  }
  else if (c == 'S') {
     stopMotors();
     suivi_piste = false;
  }
  else if (c == 'B') {
     myservo.attach(6); 
     myservo.write(2000);
     delay(700);

     myservo.detach();
     delay(100);
  }
  else if (c == 'P') {
    suivi_piste = true;
    stopMotors();   
    
  }
  
  if (suivi_piste) {
     suivre_piste();   
  }
  
  delay(10);

}