#define DIR_A 12  // Direction pin for Channel A
#define PWM_A 3   // PWM pin for Channel A
#define BRAKE_A 9 // Brake pin for Channel A

#define DIR_B 13  // Direction pin for Channel B
#define PWM_B 11  // PWM pin for Channel B
#define BRAKE_B 8 // Brake pin for Channel B

void init_moteurs() {
 
  pinMode(DIR_A, OUTPUT);
  pinMode(PWM_A, OUTPUT);
  pinMode(BRAKE_A, OUTPUT);

  pinMode(DIR_B, OUTPUT);
  pinMode(PWM_B, OUTPUT);
  pinMode(BRAKE_B, OUTPUT);
}

void reset_arduino() {
  //asm volatile("jmp 0x00");
}



void stopMotors() {
  digitalWrite(BRAKE_A, HIGH);
  digitalWrite(BRAKE_B, HIGH);
  analogWrite(PWM_A, 0);
  analogWrite(PWM_B, 0);
}

void reculer(int speed) {
  digitalWrite(DIR_A, HIGH);
  digitalWrite(DIR_B, HIGH);
  digitalWrite(BRAKE_A, LOW);
  digitalWrite(BRAKE_B, LOW);
  analogWrite(PWM_A, speed); // Adjust speed as needed
  analogWrite(PWM_B, speed);
}

void avancer(int speed) {
    digitalWrite(DIR_A, LOW);
    digitalWrite(DIR_B, LOW);
    digitalWrite(BRAKE_A, LOW);
    digitalWrite(BRAKE_B, LOW);
    analogWrite(PWM_A, speed); // Adjust speed as needed
    analogWrite(PWM_B, speed);
}

void stopper() {
    stopMotors();      
}

void gauche(int speed) {
    digitalWrite(DIR_A, LOW);
    digitalWrite(DIR_B, HIGH);
    digitalWrite(BRAKE_A, LOW);
    digitalWrite(BRAKE_B, LOW);
    analogWrite(PWM_A, speed); // Adjust speed as needed
    analogWrite(PWM_B, speed); 
}

void droite(int speed) {
    digitalWrite(DIR_A, HIGH);
    digitalWrite(DIR_B, LOW);
    digitalWrite(BRAKE_A, LOW);
    digitalWrite(BRAKE_B, LOW);
    analogWrite(PWM_A, speed); // Adjust speed as needed
    analogWrite(PWM_B, speed);
}

void  contourner_obstacle(){
  
}

// Fait avancer le moteur gauche vers l'avant à une vitesse donnée
void motorRightForward(int speed) {
  digitalWrite(DIR_A, LOW);   // Choix du sens (avant)
  digitalWrite(BRAKE_A, LOW);    // Désactivation du frein
  analogWrite(PWM_A, speed+5);     // Réglage de la vitesse
}

// Fait avancer le moteur droit vers l'avant à une vitesse donnée
void motorLeftForward(int speed) {
  digitalWrite(DIR_B, LOW);   // Choix du sens (avant)
  digitalWrite(BRAKE_B, LOW);    // Désactivation du frein
  analogWrite(PWM_B, speed);     // Réglage de la vitesse
}

void  suivre_piste(){
  int valeurGauche = analogRead(capteurGauche);
  int valeurDroit  = analogRead(capteurDroit);

  Serial.print("Gauche: ");
  Serial.print(valeurGauche);
  Serial.print(" | Droit: ");
  Serial.println(valeurDroit);

  //motorLeftForward(baseSpeed);
  //motorRightForward(baseSpeed);

   if (valeurGauche < seuil && valeurDroit < seuil) {
    // Les deux capteurs voient du blanc -> Avancer
      motorLeftForward(baseSpeed);
      motorRightForward(baseSpeed);
  } else if (valeurGauche < seuil && valeurDroit > seuil) {
    // Capteur gauche voit du blanc -> Tourner à gauche
      motorLeftForward(baseSpeed);
      motorRightForward(turnSpeed);

  } else if (valeurGauche > seuil && valeurDroit < seuil) {
    // Capteur droit voit du blanc -> Tourner à droite
      motorLeftForward(turnSpeed);
      motorRightForward(baseSpeed);
  } else {
    // Les deux voient du noir -> Stop ou faire demi-tour
    motorLeftForward(0);
    motorRightForward(0);
  }
}