#include "WiFiS3.h"
#include "WiFiUDP.h"
#include "arduino_secrets.h"

int status = WL_IDLE_STATUS;
const int Port = 5000; // Port number used
char Packet[80];
WiFiUDP udp;

void setup_wifi() {
   delay(2000);
 if (WiFi.status() == WL_NO_MODULE)
 {
 Serial.println("Communication with WiFi module failed!");
 while (true);
 }
 
 WiFi.config(IPAddress(192,168,4,4));
 Serial.print("Creating access point named: ");
 Serial.println(SECRET_SSID);
 status = WiFi.beginAP(SECRET_SSID, SECRET_PASS);
  if (status != WL_AP_LISTENING) {
     
    Serial.println("Creating access point failed");
    
    // don't continue
    while (true);
  }

  // wait 10 seconds for connection:
delay(5000);

 printWifiStatus(); // Optional
 udp.begin(Port); // listen to incoming packets
}

char read_udp() {
  int PacketSize = udp.parsePacket();
  if(PacketSize)
  {
   udp.read(Packet, PacketSize);
   Serial.println(Packet);
   return Packet[0];
  } else {
    return 'E';
  }
}

void printWifiStatus()
{
 Serial.print("SSID: ");
 Serial.println(WiFi.SSID());
 IPAddress ip = WiFi.localIP();
 Serial.print("IP Address: ");
 Serial.println(ip);
}