/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui.language;

import java.util.Locale;

public final class Language
implements Comparable<Language> {
    private final String name;
    private final String displayName;
    private final String filename;

    public Language(String name) {
        this(name, "", "");
    }

    public Language() {
        this(Locale.getDefault().getLanguage());
    }

    public Language(String name, String displayName, String filename) {
        this.name = name;
        this.displayName = displayName;
        this.filename = filename;
    }

    public String toString() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Language o) {
        return this.displayName.compareTo(o.displayName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Language language = (Language)o;
        return this.name != null ? this.name.equals(language.name) : language.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String getFileName() {
        return this.filename;
    }
}

