/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui;

import de.neemann.digital.core.element.Keys;
import de.neemann.digital.gui.Settings;
import de.neemann.gui.LineBreaker;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipProvider;
import java.awt.Dimension;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;

public abstract class ToolTipAction
extends AbstractAction {
    private Icon icon;
    private String toolTipText;
    private ToolTipProvider toolTipProvider;
    private KeyStroke accelerator;

    public ToolTipAction(String name) {
        super(name);
    }

    public ToolTipAction(String name, Icon icon) {
        super(name, icon);
        this.icon = icon;
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public ToolTipAction setToolTip(String text) {
        this.toolTipText = new LineBreaker().toHTML().breakLines(text);
        return this;
    }

    public ToolTipAction setToolTipProvider(ToolTipProvider toolTipProvider) {
        this.toolTipProvider = toolTipProvider;
        return this;
    }

    public ToolTipAction setAcceleratorCTRLplus(char key) {
        return this.setAccelerator(KeyStroke.getKeyStroke((int)key, ToolTipAction.getCTRLMask()));
    }

    public ToolTipAction setAcceleratorCTRLplus(String key) {
        int keyCode = KeyStroke.getKeyStroke(key).getKeyCode();
        return this.setAccelerator(KeyStroke.getKeyStroke(keyCode, ToolTipAction.getCTRLMask()));
    }

    public static int getCTRLMask() {
        int mask = 128;
        if (Screen.isMac()) {
            mask = 256;
        }
        return mask;
    }

    public ToolTipAction setAccelerator(String key) {
        return this.setAccelerator(KeyStroke.getKeyStroke(key));
    }

    public ToolTipAction setAccelerator(KeyStroke accelerator) {
        if (accelerator.getKeyCode() == 521 && Settings.getInstance().get(Keys.SETTINGS_USE_EQUALS_KEY).booleanValue()) {
            accelerator = KeyStroke.getKeyStroke(61, accelerator.getModifiers());
        }
        this.accelerator = accelerator;
        return this;
    }

    public ToolTipAction enableAcceleratorIn(JComponent component) {
        if (this.accelerator == null) {
            throw new RuntimeException("no accelerator given");
        }
        component.getInputMap().put(this.accelerator, this);
        component.getActionMap().put(this, this);
        return this;
    }

    public ToolTipAction setEnabledChain(boolean newValue) {
        super.setEnabled(newValue);
        return this;
    }

    public JButton createJButton() {
        JButton b = new JButton(this);
        if (this.toolTipText != null) {
            b.setToolTipText(this.toolTipText);
        }
        return b;
    }

    public JButton createJButtonNoText() {
        JButton b;
        if (this.toolTipProvider == null) {
            b = new JButton(this);
            if (this.toolTipText != null) {
                b.setToolTipText(this.toolTipText);
            } else {
                b.setToolTipText(b.getText());
            }
        } else {
            b = new JButton(this){

                @Override
                public String getToolTipText() {
                    return ToolTipAction.this.toolTipProvider.getToolTip();
                }
            };
            ToolTipManager.sharedInstance().registerComponent(b);
        }
        b.setText(null);
        b.setFocusable(false);
        return b;
    }

    public JButton createJButtonNoTextSmall() {
        JButton b = this.createJButtonNoText();
        b.setPreferredSize(new Dimension(this.icon.getIconWidth() + 4, this.icon.getIconHeight() + 4));
        return b;
    }

    public JMenuItem createJMenuItem() {
        JMenuItem i;
        if (this.toolTipProvider == null) {
            i = new JMenuItem(this);
            if (this.toolTipText != null) {
                i.setToolTipText(this.toolTipText);
            }
        } else {
            i = new JMenuItem(this){

                @Override
                public String getToolTipText() {
                    return ToolTipAction.this.toolTipProvider.getToolTip();
                }
            };
            ToolTipManager.sharedInstance().registerComponent(i);
        }
        if (this.accelerator != null) {
            i.setAccelerator(this.accelerator);
        }
        return i;
    }

    public JMenuItem createJMenuItemNoIcon() {
        JMenuItem i = this.createJMenuItem();
        i.setIcon(null);
        return i;
    }
}

