/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui;

import de.neemann.digital.core.element.Keys;
import de.neemann.digital.gui.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public final class Screen {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final boolean IS_LINUX = OS.contains("linux");
    private static final boolean IS_MAC = OS.contains("mac");
    private final int size;
    private final float scaling;
    private final Font font;

    public static Screen getInstance() {
        return InstanceHolder.instance;
    }

    private static int getDefaultScreenResolution() {
        try {
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            int widthInPixel = Toolkit.getDefaultToolkit().getScreenSize().width;
            int widthInInch = widthInPixel / dpi;
            if (widthInInch > 27) {
                dpi = widthInPixel / 27;
            }
            return dpi;
        }
        catch (HeadlessException e) {
            return 95;
        }
    }

    public static int getDefaultFontScaling() {
        if (IS_MAC) {
            return 100;
        }
        int dpi = Screen.getDefaultScreenResolution();
        int s = dpi * 100 / 96;
        if (s > 95 && s < 105) {
            s = 100;
        }
        return s;
    }

    private Screen() {
        Font font = new JLabel().getFont();
        float scaling = 1.0f;
        int size = font.getSize();
        int fontScalingPercent = Settings.getInstance().get(Keys.SETTINGS_FONT_SCALING);
        int s = fontScalingPercent * size / 100;
        if (s != size) {
            scaling = (float)s / (float)size;
            size = s;
            font = font.deriveFont((float)s);
            for (Object key : UIManager.getLookAndFeel().getDefaults().keySet()) {
                Icon icon;
                if (key.toString().endsWith(".font")) {
                    UIManager.put(key, font);
                }
                if (IS_MAC || !key.toString().endsWith(".icon") && !key.toString().endsWith("Icon") || (icon = UIManager.getIcon(key)) == null) continue;
                UIManager.put(key, new ScaleIcon(icon, scaling));
            }
            UIManager.put("ScrollBar.width", size * 17 / 12);
        }
        this.scaling = scaling;
        this.size = size;
        this.font = font;
    }

    public int getFontSize() {
        return this.size;
    }

    public Font getFont() {
        return this.font;
    }

    public Font getFont(float scale) {
        return this.font.deriveFont(this.font.getSize2D() * scale);
    }

    public float getScaling() {
        return this.scaling;
    }

    public Dimension scale(Dimension dimension) {
        if (this.scaling == 1.0f) {
            return dimension;
        }
        return new Dimension((int)((float)dimension.width * this.scaling), (int)((float)dimension.height * this.scaling));
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static void setLocation(Window w, Point pos, boolean center) {
        GraphicsDevice[] dev;
        if (pos == null) {
            return;
        }
        Rectangle screen = null;
        for (GraphicsDevice d : dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            for (GraphicsConfiguration c : d.getConfigurations()) {
                Rectangle b = c.getBounds();
                if (!b.contains(pos)) continue;
                screen = b;
            }
        }
        if (center) {
            pos.x -= w.getWidth() / 2;
            pos.y -= w.getHeight() / 2;
        }
        if (screen != null) {
            if (pos.x + w.getWidth() > screen.x + screen.width) {
                pos.x = screen.x + screen.width - w.getWidth();
            }
            if (pos.y + w.getHeight() > screen.y + screen.height) {
                pos.y = screen.y + screen.height - w.getHeight();
            }
            if (pos.x < screen.x) {
                pos.x = screen.x;
            }
            if (pos.y < screen.y) {
                pos.y = screen.y;
            }
        }
        w.setLocation(pos.x, pos.y);
    }

    private static final class ScaleIcon
    implements Icon {
        private final Icon icon;
        private final float scaling;
        private final int width;
        private final int height;

        private ScaleIcon(Icon icon, float scaling) {
            this.icon = icon;
            this.scaling = scaling;
            this.width = (int)((float)icon.getIconWidth() * scaling);
            this.height = (int)((float)icon.getIconHeight() * scaling);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            Graphics2D gr = (Graphics2D)graphics;
            AffineTransform tr = gr.getTransform();
            gr.translate(x, y);
            gr.scale(this.scaling, this.scaling);
            gr.translate(-x, -y);
            this.icon.paintIcon(component, gr, x, y);
            gr.setTransform(tr);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static final class InstanceHolder {
        private static Screen instance = new Screen();

        private InstanceHolder() {
        }
    }
}

