/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui;

import de.neemann.gui.Screen;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IconCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IconCreator.class);

    private IconCreator() {
    }

    public static Icon create(String name) {
        return new ImageIcon(IconCreator.createImage(name));
    }

    public static Image createImage(String name) {
        try {
            float scaling = Screen.getInstance().getScaling();
            if (scaling == 1.0f) {
                return IconCreator.getImage(name);
            }
            BufferedImage image = IconCreator.getImageOrNull(name.substring(0, name.length() - 4) + "_hi.png");
            if (image != null) {
                int w = (int)((float)image.getWidth() * scaling / 2.0f);
                int h = (int)((float)image.getHeight() * scaling / 2.0f);
                return image.getScaledInstance(w, h, 4);
            }
            LOGGER.info("upscaling of " + name);
            image = IconCreator.getImage(name);
            int w = (int)((float)image.getWidth() * scaling);
            int h = (int)((float)image.getHeight() * scaling);
            return image.getScaledInstance(w, h, 4);
        }
        catch (IOException e) {
            throw new RuntimeException("Image " + name + " not found", e);
        }
    }

    private static BufferedImage getImage(String name) throws IOException {
        BufferedImage image = IconCreator.getImageOrNull(name);
        if (image == null) {
            throw new NullPointerException("resource " + name + " not found!");
        }
        return image;
    }

    private static BufferedImage getImageOrNull(String name) throws IOException {
        URL systemResource = ClassLoader.getSystemResource("icons/" + name);
        if (systemResource == null) {
            return null;
        }
        return ImageIO.read(systemResource);
    }

    public static ArrayList<Image> createImages(String ... names) {
        try {
            ArrayList<Image> list = new ArrayList<Image>(names.length);
            for (String name : names) {
                list.add(IconCreator.getImage(name));
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

