/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing.parser.functions;

import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.Expression;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.digital.testing.parser.functions.Function;
import java.util.ArrayList;

public class SignExtend
extends Function {
    public SignExtend() {
        super(2);
    }

    @Override
    public long calcValue(Context c, ArrayList<Expression> args) throws ParserException {
        int bits = (int)args.get(0).value(c);
        if (bits < 0 || bits > 63) {
            throw new ParserException(Lang.get("err_invalidValue_N0_inFunction_N1", bits, "signExt"));
        }
        long value = args.get(1).value(c);
        long mask = (1L << bits) - 1L;
        long signBit = 1L << bits - 1;
        if ((value & signBit) != 0L) {
            return value & mask | mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return value & mask;
    }
}

