/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing.parser;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.data.Value;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.Expression;
import de.neemann.digital.testing.parser.LineEmitter;
import de.neemann.digital.testing.parser.LineEmitterList;
import de.neemann.digital.testing.parser.LineEmitterRepeat;
import de.neemann.digital.testing.parser.LineEmitterSimple;
import de.neemann.digital.testing.parser.LineEmitterWhile;
import de.neemann.digital.testing.parser.ModelInitializer;
import de.neemann.digital.testing.parser.OperatorPrecedence;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.digital.testing.parser.Tokenizer;
import de.neemann.digital.testing.parser.ValueAppenderBits;
import de.neemann.digital.testing.parser.VirtualSignal;
import de.neemann.digital.testing.parser.functions.Function;
import de.neemann.digital.testing.parser.functions.IfThenElse;
import de.neemann.digital.testing.parser.functions.Random;
import de.neemann.digital.testing.parser.functions.SignExtend;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;

public class Parser {
    private final ArrayList<String> names;
    private final ModelInitializer modelInit;
    private final ArrayList<VirtualSignal> virtualSignals;
    private final Tokenizer tok;
    private final HashMap<String, Function> functions = new HashMap();
    private final Random random;
    private LineEmitter emitter;

    public Parser(String data) {
        this.functions.put("signExt", new SignExtend());
        this.random = new Random();
        this.functions.put("random", this.random);
        this.functions.put("ite", new IfThenElse());
        this.names = new ArrayList();
        this.virtualSignals = new ArrayList();
        this.modelInit = new ModelInitializer();
        this.tok = new Tokenizer(new BufferedReader(new StringReader(data)));
    }

    public Parser parse() throws IOException, ParserException {
        this.parseHeader();
        this.emitter = this.parseRows(null);
        this.expect(Tokenizer.Token.EOF);
        return this;
    }

    private void parseHeader() throws IOException, ParserException {
        Tokenizer.Token token;
        this.tok.skipEmptyLines();
        block4: while (true) {
            token = this.tok.simpleIdent();
            switch (token) {
                case IDENT: {
                    String name = this.tok.getIdent();
                    if (this.names.contains(name)) {
                        throw new ParserException(Lang.get("err_nameUsedTwice_N", name));
                    }
                    this.names.add(name);
                    continue block4;
                }
                case EOL: {
                    return;
                }
            }
            break;
        }
        throw this.newUnexpectedToken(token);
    }

    private ParserException newUnexpectedToken(Tokenizer.Token token) {
        String name = token == Tokenizer.Token.IDENT ? this.tok.getIdent() : token.name();
        return new ParserException(Lang.get("err_unexpectedToken_N0_inLine_N1", name, this.tok.getLine()));
    }

    private LineEmitter parseRows(Tokenizer.Token endToken) throws IOException, ParserException {
        Tokenizer.Token t;
        LineEmitterList list = new LineEmitterList();
        block15: while (true) {
            t = this.tok.peek();
            switch (t) {
                case EOL: {
                    continue block15;
                }
                case EOF: {
                    if (endToken != null) {
                        throw this.newUnexpectedToken(t);
                    }
                    return list.minimize();
                }
                case IDENT: 
                case BITS: 
                case OPEN: 
                case NUMBER: {
                    list.add(this.parseSingleRow());
                    continue block15;
                }
                case INIT: {
                    this.tok.consume();
                    this.expect(Tokenizer.Token.IDENT);
                    String sName = this.tok.getIdent();
                    this.expect(Tokenizer.Token.EQUAL);
                    int sign = 1;
                    if (this.tok.peek() == Tokenizer.Token.SUB) {
                        this.tok.consume();
                        sign = -1;
                    }
                    this.expect(Tokenizer.Token.NUMBER);
                    long n = this.convToLong(this.tok.getIdent());
                    this.expect(Tokenizer.Token.SEMICOLON);
                    this.modelInit.initSignal(sName, (long)sign * n);
                    continue block15;
                }
                case MEMORY: {
                    this.tok.consume();
                    this.expect(Tokenizer.Token.IDENT);
                    String ramName = this.tok.getIdent();
                    this.expect(Tokenizer.Token.OPEN);
                    this.expect(Tokenizer.Token.NUMBER);
                    long addr = this.convToLong(this.tok.getIdent());
                    this.expect(Tokenizer.Token.CLOSE);
                    this.expect(Tokenizer.Token.EQUAL);
                    this.expect(Tokenizer.Token.NUMBER);
                    long val = this.convToLong(this.tok.getIdent());
                    this.expect(Tokenizer.Token.SEMICOLON);
                    this.modelInit.initMemory(ramName, (int)addr, val);
                    continue block15;
                }
                case PROGRAM: {
                    this.tok.consume();
                    this.modelInit.initProgramMemory(this.parseData());
                    continue block15;
                }
                case DECLARE: {
                    this.tok.consume();
                    this.expect(Tokenizer.Token.IDENT);
                    String sigName = this.tok.getIdent();
                    this.expect(Tokenizer.Token.EQUAL);
                    Expression sigExpression = this.parseExpression();
                    this.expect(Tokenizer.Token.SEMICOLON);
                    this.addVirtualSignal(new VirtualSignal(sigName, sigExpression));
                    continue block15;
                }
                case END: {
                    this.tok.consume();
                    this.expect(endToken);
                    return list.minimize();
                }
                case LET: {
                    this.tok.consume();
                    this.expect(Tokenizer.Token.IDENT);
                    String varName = this.tok.getIdent();
                    this.expect(Tokenizer.Token.EQUAL);
                    Expression intValue = this.parseExpression();
                    this.expect(Tokenizer.Token.SEMICOLON);
                    list.add((listener, context) -> context.setVar(varName, intValue.value(context)));
                    continue block15;
                }
                case RESETRANDOM: {
                    this.tok.consume();
                    this.expect(Tokenizer.Token.SEMICOLON);
                    list.add((listener, context) -> context.resetRandom());
                    continue block15;
                }
                case REPEAT: {
                    this.tok.consume();
                    this.expect(Tokenizer.Token.OPEN);
                    long count = this.parseInt();
                    this.expect(Tokenizer.Token.CLOSE);
                    list.add(new LineEmitterRepeat("n", count, this.parseSingleRow()));
                    continue block15;
                }
                case LOOP: {
                    this.tok.consume();
                    this.expect(Tokenizer.Token.OPEN);
                    this.expect(Tokenizer.Token.IDENT);
                    String var = this.tok.getIdent();
                    this.expect(Tokenizer.Token.COMMA);
                    long count = this.parseInt();
                    this.expect(Tokenizer.Token.CLOSE);
                    list.add(new LineEmitterRepeat(var, count, this.parseRows(Tokenizer.Token.LOOP)));
                    continue block15;
                }
                case WHILE: {
                    this.tok.consume();
                    this.expect(Tokenizer.Token.OPEN);
                    Expression condition = this.parseExpression();
                    this.expect(Tokenizer.Token.CLOSE);
                    list.add(new LineEmitterWhile(condition, this.parseRows(Tokenizer.Token.WHILE)));
                    continue block15;
                }
            }
            break;
        }
        throw this.newUnexpectedToken(t);
    }

    private DataField parseData() throws IOException, ParserException {
        Tokenizer.Token t;
        this.expect(Tokenizer.Token.OPEN);
        DataField df = new DataField();
        int addr = 0;
        block4: while (true) {
            this.expect(Tokenizer.Token.NUMBER);
            df.setData(addr, this.convToLong(this.tok.getIdent()));
            ++addr;
            t = this.tok.next();
            switch (t) {
                case COMMA: {
                    continue block4;
                }
                case CLOSE: {
                    return df;
                }
            }
            break;
        }
        throw this.newUnexpectedToken(t);
    }

    private void addVirtualSignal(VirtualSignal vs) throws ParserException {
        for (VirtualSignal v : this.virtualSignals) {
            if (!v.getName().equals(vs.getName())) continue;
            throw new ParserException(Lang.get("err_virtualSignal_N_DeclaredTwiceInLine_N", vs.getName(), this.tok.getLine()));
        }
        this.virtualSignals.add(vs);
    }

    private LineEmitter parseSingleRow() throws IOException, ParserException {
        Tokenizer.Token token;
        LineEmitterSimple line = null;
        block9: while (true) {
            token = this.tok.next();
            if (line == null) {
                line = new LineEmitterSimple(this.names.size(), this.tok.getLine());
            }
            switch (token) {
                case NUMBER: {
                    Value num = new Value(this.convToLong(this.tok.getIdent()));
                    line.add((vals, context) -> vals.add(num));
                    continue block9;
                }
                case BITS: {
                    this.expect(Tokenizer.Token.OPEN);
                    int bitCount = (int)this.parseInt();
                    this.expect(Tokenizer.Token.COMMA);
                    Expression exp = this.parseExpression();
                    line.add(new ValueAppenderBits(bitCount, exp));
                    this.expect(Tokenizer.Token.CLOSE);
                    continue block9;
                }
                case IDENT: {
                    try {
                        Value value = new Value(this.tok.getIdent().toUpperCase());
                        line.add((vals, context) -> vals.add(value));
                        continue block9;
                    }
                    catch (Bits.NumberFormatException e) {
                        throw new ParserException(Lang.get("err_notANumber_N0_inLine_N1", this.tok.getIdent(), this.tok.getLine()));
                    }
                }
                case OPEN: {
                    Expression exp = this.parseExpression();
                    line.add((vals, context) -> vals.add(new Value(exp.value(context))));
                    this.expect(Tokenizer.Token.CLOSE);
                    continue block9;
                }
                case EOL: 
                case EOF: {
                    return line;
                }
            }
            break;
        }
        throw this.newUnexpectedToken(token);
    }

    private long convToLong(String num) throws ParserException {
        try {
            return Bits.decode(num, true);
        }
        catch (Bits.NumberFormatException e) {
            throw new ParserException(Lang.get("err_notANumber_N0_inLine_N1", this.tok.getIdent(), this.tok.getLine()));
        }
    }

    private long parseInt() throws ParserException, IOException {
        return this.parseExpression().value(new Context());
    }

    private void expect(Tokenizer.Token token) throws IOException, ParserException {
        Tokenizer.Token t = this.tok.next();
        if (t != token) {
            throw this.newUnexpectedToken(t);
        }
    }

    public ArrayList<String> getNames() {
        return this.names;
    }

    public ArrayList<VirtualSignal> getVirtualSignals() {
        return this.virtualSignals;
    }

    public ModelInitializer getModelInitializer() {
        return this.modelInit;
    }

    public Random getRandom() {
        return this.random;
    }

    public LineEmitter getLines() {
        return this.emitter;
    }

    public long getValue() throws IOException, ParserException {
        return this.getValue(new Context());
    }

    public long getValue(Context context) throws IOException, ParserException {
        long value = this.parseExpression().value(context);
        this.expect(Tokenizer.Token.EOF);
        return value;
    }

    private Expression parseExpression() throws IOException, ParserException {
        return this.parseExpression(OperatorPrecedence.lowest());
    }

    private Expression parseExpression(OperatorPrecedence op) throws IOException, ParserException {
        Next next = this.getNextParser(op.getNextHigherPrecedence());
        Expression ac = next.next();
        while (this.tok.peek().getPrecedence() == op) {
            Tokenizer.Binary function = this.tok.next().getFunction();
            Expression a = ac;
            Expression b = next.next();
            ac = c -> function.op(a.value(c), b.value(c));
        }
        return ac;
    }

    private Next getNextParser(OperatorPrecedence pr) {
        if (pr == null) {
            return this::parseIdent;
        }
        return () -> this.parseExpression(pr);
    }

    private Expression parseIdent() throws IOException, ParserException {
        Tokenizer.Token t = this.tok.next();
        switch (t) {
            case IDENT: {
                String name = this.tok.getIdent();
                if (this.tok.peek() == Tokenizer.Token.OPEN) {
                    ArrayList<Expression> args = new ArrayList<Expression>();
                    do {
                        this.tok.consume();
                        args.add(this.parseExpression());
                    } while (this.tok.peek() == Tokenizer.Token.COMMA);
                    this.expect(Tokenizer.Token.CLOSE);
                    return this.findFunction(name, args);
                }
                return c -> c.getVar(name);
            }
            case NUMBER: {
                long num = this.convToLong(this.tok.getIdent());
                return c -> num;
            }
            case SUB: {
                Expression negExp = this.parseIdent();
                return c -> -negExp.value(c);
            }
            case BIN_NOT: {
                Expression notExp = this.parseIdent();
                return c -> notExp.value(c) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case LOG_NOT: {
                Expression boolNotExp = this.parseIdent();
                return c -> boolNotExp.value(c) == 0L ? 1L : 0L;
            }
            case OPEN: {
                Expression exp = this.parseExpression();
                this.expect(Tokenizer.Token.CLOSE);
                return exp;
            }
        }
        throw this.newUnexpectedToken(t);
    }

    private Expression findFunction(String name, ArrayList<Expression> args) throws ParserException {
        Function f = this.functions.get(name);
        if (f == null) {
            throw new ParserException(Lang.get("err_function_N0_notFoundInLine_N1", name, this.tok.getLine()));
        }
        if (f.getArgCount() != args.size()) {
            throw new ParserException(Lang.get("err_wrongNumOfArgsIn_N0_InLine_N1_found_N2_expected_N3", name, this.tok.getLine(), args.size(), f.getArgCount()));
        }
        return c -> f.calcValue(c, args);
    }

    private static interface Next {
        public Expression next() throws IOException, ParserException;
    }
}

