/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing;

import de.neemann.digital.data.Value;
import de.neemann.digital.data.ValueTable;
import de.neemann.digital.testing.MatchedValue;
import de.neemann.digital.testing.TestExecutor;
import de.neemann.digital.testing.TestResultListener;
import de.neemann.digital.testing.parser.TestRow;

public class TestResult
implements TestResultListener {
    private static final int MAX_RESULTS = 1024;
    private static final int ERR_RESULTS = 2048;
    private final TestExecutor testExecutor;
    private final ValueTable results;
    private int passedCount;
    private int failedCount;
    private boolean toManyResults;
    private int visibleRows;
    private int rowCount;

    TestResult(TestExecutor testExecutor) {
        this.testExecutor = testExecutor;
        this.results = new ValueTable(testExecutor.getNames());
    }

    @Override
    public void add(TestRow testRow) {
        Value[] values = testRow.getValues();
        Value[] res = new Value[values.length];
        this.testExecutor.advanceModel(testRow, values, res, this);
        boolean ok = true;
        for (TestExecutor.TestSignal out : this.testExecutor.getOutputs()) {
            MatchedValue matchedValue = new MatchedValue(values[out.getIndex()], out.getValue());
            res[out.getIndex()] = matchedValue;
            if (matchedValue.isPassed()) continue;
            ok = false;
        }
        if (ok) {
            ++this.passedCount;
        } else {
            ++this.failedCount;
        }
        if (this.visibleRows < (ok ? 1024 : 2048)) {
            ++this.visibleRows;
            this.results.add(new TestRow(res, testRow.getDescription()).setRow(this.rowCount));
        } else {
            this.toManyResults = true;
        }
        ++this.rowCount;
    }

    @Override
    public void addClockRow(String description) {
        if (this.visibleRows < 2048) {
            Value[] r = new Value[this.testExecutor.getNames().size()];
            for (TestExecutor.TestSignal out : this.testExecutor.getOutputs()) {
                r[out.getIndex()] = new Value(out.getValue());
            }
            for (TestExecutor.TestSignal in : this.testExecutor.getInputs()) {
                r[in.getIndex()] = new Value(in.getValue());
            }
            this.results.add(new TestRow(r, description)).omitInTable();
        } else {
            this.toManyResults = true;
        }
    }

    public boolean allPassed() {
        return !this.isErrorOccurred() && this.failedCount == 0 && this.passedCount > 0;
    }

    public boolean toManyResults() {
        return this.toManyResults;
    }

    public boolean isErrorOccurred() {
        return this.testExecutor.isErrorOccurred();
    }

    public int failedPercent() {
        if (this.passedCount == 0) {
            return 100;
        }
        int p = 100 * this.failedCount / (this.failedCount + this.passedCount);
        if (p == 0 && this.failedCount > 0) {
            p = 1;
        }
        return p;
    }

    public int getRowsTested() {
        return this.passedCount + this.failedCount;
    }

    public ValueTable getValueTable() {
        return this.results;
    }
}

