/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing;

import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestingDataException;
import de.neemann.digital.testing.parser.LineEmitter;
import de.neemann.digital.testing.parser.ModelInitializer;
import de.neemann.digital.testing.parser.Parser;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.digital.testing.parser.VirtualSignal;
import de.neemann.digital.testing.parser.functions.Random;
import java.io.IOException;
import java.util.ArrayList;

public class TestCaseDescription {
    private final String dataString;
    private transient LineEmitter lines;
    private transient ArrayList<String> names;
    private transient ArrayList<VirtualSignal> virtualSignals;
    private transient ModelInitializer modelInitializer;
    private transient Random random;
    private transient long seed;

    public TestCaseDescription() {
        this.dataString = "";
    }

    public TestCaseDescription(String data) throws IOException, ParserException {
        this.dataString = data;
        this.parseDataString();
    }

    public TestCaseDescription(TestCaseDescription valueToCopy) {
        this.dataString = valueToCopy.dataString;
        this.seed = valueToCopy.seed;
    }

    public void setNewSeed() {
        this.seed = 0L;
    }

    public String getDataString() {
        return this.dataString;
    }

    private void check() throws TestingDataException {
        if (this.lines == null || this.names == null) {
            try {
                this.parseDataString();
            }
            catch (ParserException | IOException e) {
                throw new TestingDataException(Lang.get("err_errorParsingTestdata", new Object[0]), e);
            }
        }
        if (this.seed == 0L) {
            this.seed = System.currentTimeMillis();
        }
        this.random.setSeed(this.seed);
    }

    public void resetSeed() {
        this.random.setSeed(this.seed);
    }

    private void parseDataString() throws IOException, ParserException {
        Parser tdp = new Parser(this.dataString).parse();
        this.lines = tdp.getLines();
        this.names = tdp.getNames();
        this.virtualSignals = tdp.getVirtualSignals();
        this.modelInitializer = tdp.getModelInitializer();
        this.random = tdp.getRandom();
    }

    public LineEmitter getLines() throws TestingDataException {
        this.check();
        return this.lines;
    }

    public ArrayList<String> getNames() throws TestingDataException {
        this.check();
        return this.names;
    }

    public ArrayList<VirtualSignal> getVirtualSignals() throws TestingDataException {
        this.check();
        return this.virtualSignals;
    }

    public ModelInitializer getModelInitializer() throws TestingDataException {
        this.check();
        return this.modelInitializer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseDescription testCaseDescription = (TestCaseDescription)o;
        return this.dataString != null ? this.dataString.equals(testCaseDescription.dataString) : testCaseDescription.dataString == null;
    }

    public int hashCode() {
        return this.dataString != null ? this.dataString.hashCode() : 0;
    }

    public String toString() {
        return this.dataString;
    }
}

