/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.vhdl2.entities;

import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.Value;
import de.neemann.digital.hdl.vhdl2.VHDLCreator;
import java.util.ArrayList;

public final class VHDLTemplateFunctions {
    private ArrayList<Generic> generics = new ArrayList();

    VHDLTemplateFunctions() {
    }

    public static String zero(long bits) {
        if (bits == 1L) {
            return "'0'";
        }
        return "(others => '0')";
    }

    public static String value(long val, long bits) {
        return VHDLCreator.value(val, (int)bits);
    }

    public static String genericType(long n) {
        if (n == 1L) {
            return "std_logic";
        }
        return "std_logic_vector ((Bits-1) downto 0)";
    }

    public static String type(long n) {
        if (n == 1L) {
            return "std_logic";
        }
        return "std_logic_vector (" + (n - 1L) + " downto 0)";
    }

    public void registerGeneric(String ... args) throws HGSEvalException {
        if (args.length == 1) {
            this.generics.add(new Generic(args[0], "integer"));
        } else if (args.length == 2) {
            this.generics.add(new Generic(args[0], args[1]));
        } else {
            throw new HGSEvalException("wrong number of arguments");
        }
    }

    ArrayList<Generic> getGenerics() {
        return this.generics;
    }

    public static final class Generic {
        private final String name;
        private final String type;

        private Generic(String name, String type) {
            this.name = name;
            this.type = type.toLowerCase();
        }

        public String getName() {
            return this.name;
        }

        public String format(Object val) throws HGSEvalException {
            switch (this.type) {
                case "integer": {
                    return Long.toString(Value.toLong(val));
                }
                case "real": {
                    return Double.toString(Value.toDouble(val));
                }
                case "std_logic": {
                    return "'" + (Value.toBool(val) ? 1 : 0) + "'";
                }
            }
            throw new HGSEvalException("type " + this.type + " not allowed as generic");
        }
    }
}

