/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.vhdl2;

import de.neemann.digital.data.Value;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.vhdl2.Separator;
import de.neemann.digital.hdl.vhdl2.VHDLCreator;
import de.neemann.digital.hdl.vhdl2.VHDLRenaming;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.digital.testing.TestingDataException;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.LineListener;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.digital.testing.parser.TestRow;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VHDLTestBenchCreator {
    private final List<Circuit.TestCase> testCases;
    private final HDLCircuit main;
    private final HDLModel.Renaming renaming;
    private ArrayList<File> testFileWritten;

    VHDLTestBenchCreator(Circuit circuit, HDLModel model) {
        this.main = model.getMain();
        this.renaming = model.getRenaming();
        this.testCases = circuit.getTestCases();
        this.testFileWritten = new ArrayList();
    }

    public VHDLTestBenchCreator write(File file) throws IOException, HDLException {
        String filename = file.getName();
        int p = filename.indexOf(46);
        if (p > 0) {
            filename = filename.substring(0, p);
        }
        VHDLRenaming renaming = new VHDLRenaming();
        for (Circuit.TestCase tc : this.testCases) {
            if (tc.hasGenericCode()) {
                throw new HDLException(Lang.get("err_hdlTestCaseHasGenericCode", new Object[0]));
            }
            String testName = tc.getLabel();
            testName = testName.length() > 0 ? filename + "_" + renaming.checkName(testName) + "_tb" : filename + "_tb";
            File f = new File(file.getParentFile(), testName + ".vhdl");
            this.testFileWritten.add(f);
            try (CodePrinter out = new CodePrinter(f);){
                try {
                    this.writeTestBench(out, testName, tc);
                }
                catch (TestingDataException | ParserException | RuntimeException e) {
                    throw new HDLException(Lang.get("err_vhdlErrorWritingTestBench", new Object[0]), e);
                }
            }
        }
        return this;
    }

    public ArrayList<File> getTestFileWritten() {
        return this.testFileWritten;
    }

    private void writeTestBench(CodePrinter out, String testName, Circuit.TestCase tc) throws IOException, TestingDataException, ParserException {
        out.print("--  A testbench for ").println(testName);
        out.println("LIBRARY ieee;");
        out.println("USE ieee.std_logic_1164.all;");
        out.println("USE ieee.numeric_std.all;");
        out.println();
        out.print("entity ").print(testName).println(" is");
        out.print("end ").print(testName).println(";");
        out.println();
        out.print("architecture behav of ").print(testName).println(" is").inc();
        out.println("component main").inc();
        VHDLCreator.writePorts(out, this.main);
        out.dec().println("end component;");
        out.println();
        for (HDLPort hDLPort : this.main.getInputs()) {
            out.print("signal ").print(hDLPort.getName()).print(" : ").print(VHDLCreator.getType(hDLPort.getBits())).println(";");
        }
        for (HDLPort hDLPort : this.main.getOutputs()) {
            out.print("signal ").print(hDLPort.getName()).print(" : ").print(VHDLCreator.getType(hDLPort.getBits())).println(";");
        }
        out.print("function to_string ( a: std_logic_vector) return string is\n    variable b : string (1 to a'length) := (others => NUL);\n    variable stri : integer := 1; \nbegin\n    for i in a'range loop\n        b(stri) := std_logic'image(a((i)))(2);\n    stri := stri+1;\n    end loop;\n    return b;\nend function;\n");
        out.dec().println("begin").inc();
        out.println("main_0 : main port map (").inc();
        Separator comma = new Separator(out, ",\n");
        for (HDLPort p : this.main.getInputs()) {
            comma.check();
            out.print(p.getName() + " => " + p.getName());
        }
        for (HDLPort p : this.main.getOutputs()) {
            comma.check();
            out.print(p.getName() + " => " + p.getName());
        }
        out.println(" );").dec();
        out.println("process").inc();
        TestCaseDescription testCaseDescription = tc.getTestCaseDescription();
        ArrayList<HDLPort> dataOrder = new ArrayList<HDLPort>();
        out.println("type pattern_type is record").inc();
        for (String name : testCaseDescription.getNames()) {
            String saveName = this.renaming.checkName(name);
            boolean found = false;
            for (HDLPort p : this.main.getPorts()) {
                if (!p.getName().equals(saveName)) continue;
                out.print(p.getName()).print(" : ").print(VHDLCreator.getType(p.getBits())).println(";");
                dataOrder.add(p);
                found = true;
                break;
            }
            if (found) continue;
            throw new TestingDataException(Lang.get("err_testSignal_N_notFound", name));
        }
        out.dec().println("end record;");
        out.println("type pattern_array is array (natural range <>) of pattern_type;");
        out.println("constant patterns : pattern_array := (").inc();
        LineListenerVHDL parent = new LineListenerVHDL(out, dataOrder);
        testCaseDescription.getLines().emitLines(parent, new Context());
        out.println(");").dec();
        String loopVar = "i";
        int lv = 0;
        while (this.loopVarExists(loopVar, this.main.getPorts())) {
            loopVar = "i" + lv++;
        }
        out.dec().println("begin").inc();
        out.print("for ").print(loopVar).println(" in patterns'range loop").inc();
        for (HDLPort p : this.main.getInputs()) {
            out.print(p.getName()).print(" <= patterns(").print(loopVar).print(").").print(p.getName()).println(";");
        }
        out.println("wait for 10 ns;");
        for (HDLPort p : this.main.getOutputs()) {
            out.print("assert std_match(").print(p.getName()).print(", patterns(").print(loopVar).print(").").print(p.getName()).print(")");
            out.print(" OR (").print(p.getName()).print(" = ").print(VHDLTestBenchCreator.getSimpleValue(p.getBits(), 'Z')).print(" AND patterns(").print(loopVar).print(").").print(p.getName()).print(" = ").print(VHDLTestBenchCreator.getSimpleValue(p.getBits(), 'Z')).print(")").eol();
            out.inc().print("report \"wrong value for ").print(p.getName()).print(", ").print(loopVar).print("=\" & integer'image(").print(loopVar).println(")").print(" & \", expected \"").print(" & ").print(this.convertFunc(p)).print("(patterns(").print(loopVar).print(").").print(p.getName()).print(")").print(" & \", found \"").print(" & ").print(this.convertFunc(p)).print("(").print(p.getName()).print(")").print(" severity error;").dec();
        }
        out.dec().println("end loop;");
        out.println("wait;");
        out.dec().println("end process;");
        out.dec().println("end behav;");
    }

    private String convertFunc(HDLPort p) {
        if (p.getBits() > 1) {
            return "to_string";
        }
        return "std_logic'image";
    }

    private boolean loopVarExists(String loopVar, ArrayList<HDLPort> ports) {
        for (HDLPort p : ports) {
            if (!p.getName().equalsIgnoreCase(loopVar)) continue;
            return true;
        }
        return false;
    }

    private static String getSimpleValue(int bits, char c) {
        if (bits == 1) {
            return "'" + c + "'";
        }
        StringBuilder sb = new StringBuilder("\"");
        for (int i = 0; i < bits; ++i) {
            sb.append(c);
        }
        return sb.append('\"').toString();
    }

    private static final class LineListenerVHDL
    implements LineListener {
        private final CodePrinter out;
        private final ArrayList<HDLPort> dataOrder;
        private final Separator lineSep;
        private int line = 0;

        private LineListenerVHDL(CodePrinter out, ArrayList<HDLPort> dataOrder) {
            this.out = out;
            this.dataOrder = dataOrder;
            this.lineSep = new Separator(out, ""){

                @Override
                public void printSeparator(CodePrinter out) throws IOException {
                    out.print(", -- i=").print(line++).print("\n");
                }
            };
        }

        @Override
        public void add(TestRow testRow) {
            try {
                boolean containsClock = false;
                for (Value v : testRow.getValues()) {
                    if (v.getType() != Value.Type.CLOCK) continue;
                    containsClock = true;
                }
                if (containsClock) {
                    this.lineSep.check();
                    this.writeValues(testRow.getValues(), true, 0);
                    this.lineSep.check();
                    this.writeValues(testRow.getValues(), true, 1);
                }
                this.lineSep.check();
                this.writeValues(testRow.getValues(), false, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void writeValues(Value[] values, boolean isClock, int clock) throws IOException {
            this.out.print("(");
            Separator sep = new Separator(this.out, ", ");
            block6: for (int i = 0; i < values.length; ++i) {
                sep.check();
                Value val = values[i];
                int bits = this.dataOrder.get(i).getBits();
                switch (val.getType()) {
                    case NORMAL: {
                        if (isClock && this.dataOrder.get(i).getDirection() == HDLPort.Direction.IN) {
                            this.out.print(VHDLTestBenchCreator.getSimpleValue(bits, '-'));
                            continue block6;
                        }
                        this.out.print(VHDLCreator.value(val.getValue(), bits));
                        continue block6;
                    }
                    case DONTCARE: {
                        this.out.print(VHDLTestBenchCreator.getSimpleValue(bits, '-'));
                        continue block6;
                    }
                    case HIGHZ: {
                        this.out.print(VHDLTestBenchCreator.getSimpleValue(bits, 'Z'));
                        continue block6;
                    }
                    case CLOCK: {
                        this.out.print("'").print(clock).print("'");
                        continue block6;
                    }
                    default: {
                        throw new RuntimeException(Lang.get("err_vhdlValuesOfType_N_notAllowed", new Object[]{val.getType()}));
                    }
                }
            }
            this.out.print(")");
        }
    }
}

