/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.vhdl2;

import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.vhdl2.entities.VHDLEntity;
import de.neemann.digital.hdl.vhdl2.entities.VHDLTemplate;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VHDLLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(VHDLLibrary.class);
    private final ElementLibrary library;
    private HashMap<String, VHDLEntity> map;

    VHDLLibrary(ElementLibrary library) {
        this.library = library;
        this.map = new HashMap();
    }

    public VHDLEntity getEntity(HDLNode node) throws HDLException {
        String elementName = node.getElementName();
        VHDLEntity e = this.map.get(elementName);
        if (e == null) {
            try {
                ClassLoader cl = null;
                try {
                    cl = this.library.getElementType(elementName).getClassLoader();
                }
                catch (ElementNotFoundException elementNotFoundException) {
                    // empty catch block
                }
                e = new VHDLTemplate(elementName, cl);
                this.map.put(elementName, e);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                LOGGER.info("could not load '" + VHDLTemplate.neededFileName(elementName) + "'");
            }
        }
        if (e == null) {
            throw new HDLException(Lang.get("err_vhdlNoEntity_N", elementName));
        }
        return e;
    }
}

