/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.vhdl2;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLNodeAssignment;
import de.neemann.digital.hdl.model2.HDLNodeBuildIn;
import de.neemann.digital.hdl.model2.HDLNodeCustom;
import de.neemann.digital.hdl.model2.HDLNodeSplitterManyToOne;
import de.neemann.digital.hdl.model2.HDLNodeSplitterOneToMany;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.ExprConstant;
import de.neemann.digital.hdl.model2.expression.ExprNot;
import de.neemann.digital.hdl.model2.expression.ExprOperate;
import de.neemann.digital.hdl.model2.expression.ExprVar;
import de.neemann.digital.hdl.model2.expression.ExprVarRange;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.vhdl2.Separator;
import de.neemann.digital.hdl.vhdl2.VHDLLibrary;
import de.neemann.digital.hdl.vhdl2.entities.VHDLEntity;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VHDLCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(VHDLCreator.class);
    private static final String ZEROS = "0000000000000000000000000000000000000000000000000000000000000000";
    private final CodePrinter out;
    private final VHDLLibrary library;
    private HashSet<String> customPrinted;

    VHDLCreator(CodePrinter out, ElementLibrary lib) {
        this.out = out;
        this.library = new VHDLLibrary(lib);
        this.customPrinted = new HashSet();
    }

    public static String getType(int bits) {
        if (bits == 1) {
            return "std_logic";
        }
        return "std_logic_vector(" + (bits - 1) + " downto 0)";
    }

    public static String value(ExprConstant con) {
        return VHDLCreator.value(con.getValue(), con.getBits());
    }

    public static String value(long val, int bits) {
        String s = Long.toBinaryString(val & Bits.mask(bits));
        int missing = bits - s.length();
        if (missing > 0) {
            s = ZEROS.substring(0, missing) + s;
        }
        s = bits > 1 ? "\"" + s + "\"" : "'" + s + "'";
        return s;
    }

    private void printNodeBuiltIn(HDLNodeBuildIn node, File root) throws HDLException, IOException, HGSEvalException {
        VHDLEntity entity = this.library.getEntity(node);
        String hdlEntityName = entity.print(this.out, node, root);
        node.setHdlEntityName(hdlEntityName);
    }

    private void printNodeCustom(HDLNodeCustom node, File root) throws HDLException, IOException, HGSEvalException {
        if (!this.customPrinted.contains(node.getElementName())) {
            this.printHDLCircuit(node.getCircuit(), root);
            this.customPrinted.add(node.getElementName());
        }
    }

    public void printHDLCircuit(HDLCircuit circuit, File root) throws IOException, HDLException, HGSEvalException {
        if (circuit.shouldSkipHDLExport()) {
            return;
        }
        for (HDLNode node : circuit) {
            if (node instanceof HDLNodeCustom) {
                this.printNodeCustom((HDLNodeCustom)node, root);
                continue;
            }
            if (!(node instanceof HDLNodeBuildIn)) continue;
            this.printNodeBuiltIn((HDLNodeBuildIn)node, root);
        }
        LOGGER.info("export " + circuit.getElementName());
        this.out.println().println("LIBRARY ieee;").println("USE ieee.std_logic_1164.all;").println("USE ieee.numeric_std.all;").println();
        if (circuit.hasDescription()) {
            this.out.printComment("-- ", circuit.getDescription());
        }
        this.out.print("entity ").print(circuit.getHdlEntityName()).println(" is").inc();
        VHDLCreator.writePorts(this.out, circuit);
        this.out.dec();
        this.out.print("end ").print(circuit.getHdlEntityName()).println(";");
        this.out.println();
        this.out.print("architecture Behavioral of " + circuit.getHdlEntityName()).println(" is").inc();
        for (HDLNet net : circuit.getNets()) {
            if (!net.needsVariable()) continue;
            this.out.print("signal ").print(net.getName()).print(": ").print(VHDLCreator.getType(net.getBits())).println(";");
        }
        this.out.dec().println("begin").inc();
        int num = 0;
        for (HDLNode node : circuit) {
            if (node instanceof HDLNodeAssignment) {
                this.printExpression((HDLNodeAssignment)node);
                continue;
            }
            if (node instanceof HDLNodeBuildIn) {
                this.printEntityInstantiation((HDLNodeBuildIn)node, num++, root);
                continue;
            }
            if (node instanceof HDLNodeSplitterOneToMany) {
                this.printOneToMany((HDLNodeSplitterOneToMany)node);
                continue;
            }
            if (node instanceof HDLNodeSplitterManyToOne) {
                this.printManyToOne((HDLNodeSplitterManyToOne)node);
                continue;
            }
            throw new HDLException("Not yet implemented: " + node.getClass().getSimpleName());
        }
        for (HDLPort p : circuit.getOutputs()) {
            HDLNet net = p.getNet();
            if (!net.needsVariable() && !net.isInput()) continue;
            this.out.print(p.getName()).print(" <= ").print(p.getNet().getName()).println(";");
        }
        this.out.dec().println("end Behavioral;");
    }

    public static void writePorts(CodePrinter out, HDLCircuit circuit) throws IOException {
        out.println("port (").inc();
        Separator sep = new Separator(out, ";\n");
        for (HDLPort i : circuit.getInputs()) {
            sep.check();
            out.print(i.getName()).print(": ").print(VHDLCreator.getDir(i.getDirection(), "in")).print(" ").print(VHDLCreator.getType(i.getBits()));
            if (!i.hasDescription()) continue;
            sep.setLineFinalizer(ou -> ou.printComment(" -- ", i.getDescription()));
        }
        for (HDLPort o : circuit.getOutputs()) {
            sep.check();
            out.print(o.getName()).print(": ").print(VHDLCreator.getDir(o.getDirection(), "out")).print(" ").print(VHDLCreator.getType(o.getBits()));
            if (!o.hasDescription()) continue;
            sep.setLineFinalizer(ou -> ou.printComment(" -- ", o.getDescription()));
        }
        sep.close();
        out.println(");").dec();
    }

    private static String getDir(HDLPort.Direction direction, String def) {
        if (direction == HDLPort.Direction.INOUT) {
            return "inout";
        }
        return def;
    }

    private void printManyToOne(HDLNodeSplitterManyToOne node) throws IOException, HDLException {
        String target = node.getTargetSignal();
        if (target != null) {
            for (HDLNodeSplitterManyToOne.SplitterAssignment in : node) {
                this.out.print(target).print("(");
                if (in.getLsb() == in.getMsb()) {
                    this.out.print(in.getLsb());
                } else {
                    this.out.print(in.getMsb()).print(" downto ").print(in.getLsb());
                }
                this.out.print(") <= ");
                this.printExpression(in.getExpression());
                this.out.println(";");
            }
        }
    }

    private void printOneToMany(HDLNodeSplitterOneToMany node) throws IOException {
        String source = node.getSourceSignal();
        Splitter.Ports is = node.getOutputSplit();
        int i = 0;
        for (HDLPort outPort : node.getOutputs()) {
            Splitter.Port sp = is.getPort(i++);
            if (outPort.getNet() == null) continue;
            this.out.print(outPort.getNet().getName()).print(" <= ").print(source).print("(");
            if (outPort.getBits() == 1) {
                this.out.print(sp.getPos());
            } else {
                this.out.print(sp.getPos() + sp.getBits() - 1).print(" downto ").print(sp.getPos());
            }
            this.out.println(");");
        }
    }

    private void printEntityInstantiation(HDLNodeBuildIn node, int num, File root) throws IOException, HDLException {
        String entityName = node.getHdlEntityName();
        this.out.print("gate").print(num).print(": entity work.").print(entityName);
        String label = node.getElementAttributes().getLabel();
        if (label != null && label.length() > 0) {
            this.out.print(" -- ").print(label.replace('\n', ' '));
        }
        this.out.println().inc();
        if (!(node instanceof HDLNodeCustom)) {
            this.library.getEntity(node).writeGenericMap(this.out, node, root);
        }
        this.out.println("port map (").inc();
        Separator sep = new Separator(this.out, ",\n");
        for (HDLNodeBuildIn.InputAssignment i : node) {
            sep.check();
            this.out.print(i.getTargetName()).print(" => ");
            this.printExpression(i.getExpression());
        }
        for (HDLPort o : node.getOutputs()) {
            if (o.getNet() == null) continue;
            sep.check();
            this.out.print(o.getName()).print(" => ").print(o.getNet().getName());
        }
        for (HDLPort o : node.getInOutputs()) {
            if (o.getNet() == null) continue;
            sep.check();
            this.out.print(o.getName()).print(" => ").print(o.getNet().getName());
        }
        this.out.println(");").dec().dec();
    }

    private void printExpression(HDLNodeAssignment node) throws IOException, HDLException {
        if (node.getTargetNet() != null) {
            this.out.print(node.getTargetNet().getName()).print(" <= ");
            this.printExpression(node.getExpression());
            this.out.println(";");
        }
    }

    private void printExpression(Expression expression) throws IOException, HDLException {
        if (expression instanceof ExprVar) {
            this.out.print(((ExprVar)expression).getNet().getName());
        } else if (expression instanceof ExprVarRange) {
            ExprVarRange evr = (ExprVarRange)expression;
            this.out.print(evr.getNet().getName()).print("(");
            if (evr.getMsb() == evr.getLsb()) {
                this.out.print(evr.getMsb());
            } else {
                this.out.print(evr.getMsb()).print(" downto ").print(evr.getLsb());
            }
            this.out.print(")");
        } else if (expression instanceof ExprConstant) {
            ExprConstant constant = (ExprConstant)expression;
            this.out.print(VHDLCreator.value(constant));
        } else if (expression instanceof ExprNot) {
            this.out.print("NOT ");
            Expression inner = ((ExprNot)expression).getExpression();
            if (inner instanceof ExprNot) {
                this.out.print("(");
                this.printExpression(inner);
                this.out.print(")");
            } else {
                this.printExpression(inner);
            }
        } else if (expression instanceof ExprOperate) {
            String op;
            this.out.print("(");
            boolean first = true;
            ExprOperate operate = (ExprOperate)expression;
            switch (operate.getOperation()) {
                case OR: {
                    op = " OR ";
                    break;
                }
                case AND: {
                    op = " AND ";
                    break;
                }
                case XOR: {
                    op = " XOR ";
                    break;
                }
                default: {
                    throw new HDLException("unknown operation " + (Object)((Object)operate.getOperation()));
                }
            }
            for (Expression exp : operate.getOperands()) {
                if (first) {
                    first = false;
                } else {
                    this.out.print(op);
                }
                this.printExpression(exp);
            }
            this.out.print(")");
        } else {
            throw new HDLException("expression type " + expression.getClass().getSimpleName() + " unknown");
        }
    }
}

