/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.verilog2;

import de.neemann.digital.hdl.model2.HDLModel;
import java.util.Arrays;
import java.util.HashSet;

public class VerilogRenaming
implements HDLModel.Renaming {
    private static final HashSet<String> KEYWORDS = new HashSet<String>(Arrays.asList("always", "and", "assign", "automatic", "begin", "buf", "bufif0", "bufif1", "case", "casex", "casez", "cell", "cmos", "config", "deassign", "default", "defparam", "design", "disable", "edge", "else", "end", "endcase", "endconfig", "endfunction", "endgenerate", "endmodule", "endprimitive", "endspecify", "endtable", "endtask", "event", "for", "force", "forever", "fork", "function", "generate", "genvar", "highz0", "highz1", "if", "ifnone", "incdir", "include", "initial", "inout", "input", "instance", "integer", "join", "large", "liblist", "library", "localparam", "macromodule", "medium", "module", "nand", "negedge", "nmos", "nor", "noshowcancelledno", "not", "notif0", "notif1", "or", "output", "parameter", "pmos", "posedge", "primitive", "pull0", "pull1", "pulldown", "pullup", "pulsestyle_oneventglitch", "pulsestyle_ondetectglitch", "remos", "real", "realtime", "reg", "release", "repeat", "rnmos", "rpmos", "rtran", "rtranif0", "rtranif1", "scalared", "showcancelled", "signed", "small", "specify", "specparam", "strong0", "strong1", "supply0", "supply1", "table", "task", "time", "tran", "tranif0", "tranif1", "tri", "tri0", "tri1", "triand", "trior", "trireg", "unsigned", "use", "vectored", "wait", "wand", "weak0", "weak1", "while", "wire", "wor", "xnor", "xor"));

    @Override
    public String checkName(String name) {
        if (this.isKeyword(name) || !this.isFirstCharValid(name)) {
            return "\\" + this.replaceWhitespace(name) + " ";
        }
        return this.cleanName(name);
    }

    private String replaceWhitespace(String name) {
        return name.replace(' ', '_').replace('\t', '_');
    }

    private boolean isFirstCharValid(String name) {
        char c = name.charAt(0);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean isKeyword(String str) {
        return KEYWORDS.contains(str.toLowerCase());
    }

    private String cleanName(String name) {
        StringBuilder sb = new StringBuilder();
        boolean needScaping = false;
        block5: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$') {
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    sb.append("_");
                    continue block5;
                }
                case '!': 
                case '/': 
                case '~': 
                case '\u00ac': {
                    sb.append("not");
                    continue block5;
                }
                default: {
                    sb.append(c);
                    needScaping = true;
                }
            }
        }
        if (needScaping) {
            sb.insert(0, "\\");
            sb.append(" ");
        }
        return sb.toString();
    }
}

