/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.verilog2;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.clock.HDLClockIntegrator;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.verilog2.VerilogCreator;
import de.neemann.digital.hdl.verilog2.VerilogRenaming;
import de.neemann.digital.hdl.verilog2.VerilogTestBenchCreator;
import de.neemann.digital.lang.Lang;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class VerilogGenerator
implements Closeable {
    private final ElementLibrary library;
    private final CodePrinter out;
    private ArrayList<File> testBenches;
    private HDLModel model;
    private HDLClockIntegrator clockIntegrator;

    public VerilogGenerator(ElementLibrary library, CodePrinter out) {
        this.library = library;
        this.out = out;
    }

    public void setClockIntegrator(HDLClockIntegrator clockIntegrator) {
        this.clockIntegrator = clockIntegrator;
    }

    public VerilogGenerator export(Circuit circuit) throws IOException {
        try {
            if (!circuit.getAttributes().get(Keys.ROMMANAGER).isEmpty()) {
                throw new HDLException(Lang.get("err_centralDefinedRomsAreNotSupported", new Object[0]));
            }
            this.model = new HDLModel(this.library).create(circuit, this.clockIntegrator);
            for (Object hdlCircuit : this.model) {
                ((HDLCircuit)hdlCircuit).applyDefaultOptimizations();
            }
            VerilogRenaming vrename = new VerilogRenaming();
            this.model.renameLabels(vrename);
            for (HDLCircuit hdlCircuit : this.model) {
                this.checkForUniqueNetNames(hdlCircuit);
            }
            this.out.println("/*");
            this.out.println(" * Generated by Digital. Don't modify this file!");
            this.out.println(" * Any changes will be lost if this file is regenerated.");
            this.out.println(" */");
            String fileName = this.out.getFile() != null ? this.out.getFile().getName() : circuit.getOrigin().getName();
            String[] tokens = fileName.split("(?=(\\.[^\\.]+)$)");
            String topModuleName = vrename.checkName(tokens[0]);
            new VerilogCreator(this.out, this.library).printHDLCircuit(this.model.getMain(), topModuleName, this.model.getRoot());
            File outFile = this.out.getFile();
            if (outFile != null) {
                this.testBenches = new VerilogTestBenchCreator(circuit, this.model, topModuleName).write(outFile).getTestFileWritten();
            }
            return this;
        }
        catch (NodeException | PinException | ElementNotFoundException | HGSEvalException | HDLException | NullPointerException e) {
            throw new IOException(Lang.get("err_verilogExporting", new Object[0]), e);
        }
    }

    private void checkForUniqueNetNames(HDLCircuit hdlCircuit) throws HDLException {
        ArrayList<HDLNet> nets = hdlCircuit.getNets();
        for (HDLNet n : nets) {
            if (!n.isUserNamed()) continue;
            for (HDLNet nn : nets) {
                if (!n.getName().equalsIgnoreCase(nn.getName()) || n == nn) continue;
                String newName = "s_" + n.getName();
                int i = 1;
                while (this.exits(newName, nets)) {
                    newName = "s_" + n.getName() + i++;
                }
                n.setName(newName);
            }
        }
        for (int i = 0; i < nets.size(); ++i) {
            HDLNet n1 = nets.get(i);
            for (int j = i + 1; j < nets.size(); ++j) {
                HDLNet n2 = nets.get(j);
                if (!n1.getName().equalsIgnoreCase(n2.getName())) continue;
                throw new HDLException(Lang.get("err_namesAreNotUnique_N", n1.getName() + "==" + n2.getName()), hdlCircuit.getOrigin());
            }
        }
    }

    private boolean exits(String newName, ArrayList<HDLNet> nets) {
        for (HDLNet n : nets) {
            if (!n.getName().equalsIgnoreCase(newName)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<File> getTestBenches() {
        return this.testBenches;
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public HDLModel getModel() {
        return this.model;
    }
}

