/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.printer;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CodePrinter
implements Closeable {
    private static final String CHARSET = "ISO8859-1";
    protected final OutputStream out;
    private final int indentWidth;
    private File file;
    private int ident = 0;
    private boolean newLine = true;
    private int pos;

    public CodePrinter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file), 2);
        this.file = file;
    }

    public CodePrinter(OutputStream out) {
        this(out, 2);
    }

    public CodePrinter(OutputStream out, int indentWidth) {
        this.indentWidth = indentWidth;
        this.out = out instanceof ByteArrayOutputStream || out instanceof BufferedOutputStream ? out : new BufferedOutputStream(out);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public CodePrinter println(String str) throws IOException {
        this.print(str);
        this.println();
        return this;
    }

    public CodePrinter println() throws IOException {
        this.print('\n');
        return this;
    }

    public void eol() throws IOException {
        this.print('\n');
    }

    public CodePrinter print(String str) throws IOException {
        if (str == null) {
            str = "null";
        }
        for (int i = 0; i < str.length(); ++i) {
            this.print(str.charAt(i));
        }
        return this;
    }

    public CodePrinter print(int i) throws IOException {
        this.print(Integer.toString(i));
        return this;
    }

    public CodePrinter print(long l) throws IOException {
        this.print(Long.toString(l));
        return this;
    }

    public CodePrinter print(char c) throws IOException {
        if (this.newLine && c != '\n') {
            this.pos = this.ident * this.indentWidth;
            for (int i = 0; i < this.pos; ++i) {
                this.out.write(32);
            }
            this.newLine = false;
        }
        if (c < '\u0080') {
            this.out.write(c);
        } else {
            this.out.write(("" + c).getBytes(CHARSET));
        }
        ++this.pos;
        if (c == '\n') {
            this.newLine = true;
            this.eolIsWritten();
        }
        return this;
    }

    protected void eolIsWritten() throws IOException {
    }

    public CodePrinter inc() {
        ++this.ident;
        return this;
    }

    public CodePrinter dec() {
        if (this.ident > 0) {
            --this.ident;
        }
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public CodePrinter printComment(String singleLineComment, String comment) throws IOException {
        if (comment == null || comment.length() == 0) {
            return this;
        }
        int startPos = this.pos;
        if (this.newLine) {
            startPos = this.ident * this.indentWidth;
        }
        this.print(singleLineComment);
        for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            this.print(c);
            if (c != '\n') continue;
            int spaceCount = startPos - this.ident * this.indentWidth;
            for (int j = 0; j < spaceCount; ++j) {
                this.print(' ');
            }
            this.print(singleLineComment);
        }
        this.println();
        return this;
    }
}

