/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.optimizations;

import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.ExprConstant;
import de.neemann.digital.hdl.model2.expression.ExprVar;
import de.neemann.digital.hdl.model2.optimizations.Optimization;
import java.util.ArrayList;

public class MergeConstants
implements Optimization {
    private HDLCircuit circuit;

    @Override
    public void optimize(HDLCircuit circuit) throws HDLException {
        this.circuit = circuit;
        ArrayList<HDLNode> nodes = circuit.getNodes();
        for (int n1 = 0; n1 < nodes.size(); ++n1) {
            HDLNode node1 = nodes.get(n1);
            ExprConstant con1 = ExprConstant.isConstant(node1);
            if (con1 == null) continue;
            for (int n2 = n1 + 1; n2 < nodes.size(); ++n2) {
                HDLNode node2 = nodes.get(n2);
                ExprConstant con2 = ExprConstant.isConstant(node2);
                if (con2 == null || !con1.isEqualTo(con2)) continue;
                this.merge(node1, node2);
                nodes.remove(n2);
                --n2;
            }
        }
    }

    private void merge(HDLNode node1, HDLNode node2) throws HDLException {
        HDLNet usedNet = node1.getOutput().getNet();
        HDLNet obsoleteNet = node2.getOutput().getNet();
        ArrayList<HDLPort> ins = obsoleteNet.getInputs();
        for (HDLPort p : ins.toArray(new HDLPort[ins.size()])) {
            p.setNet(usedNet);
        }
        this.circuit.replaceNetByExpression(obsoleteNet, new ExprVar(usedNet));
        this.circuit.removeNet(obsoleteNet);
    }
}

