/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.expression;

import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.expression.ExpressionOptimizer;
import de.neemann.digital.hdl.model2.expression.Visitor;
import de.neemann.digital.hdl.printer.CodePrinter;
import java.io.IOException;
import java.util.ArrayList;

public class ExprOperate
implements Expression {
    private Operation operation;
    private ArrayList<Expression> operands;

    public ExprOperate(Operation operation, ArrayList<Expression> operands) {
        this.operation = operation;
        this.operands = operands;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public ArrayList<Expression> getOperands() {
        return this.operands;
    }

    @Override
    public void print(CodePrinter out) throws IOException {
        out.print("(");
        boolean first = true;
        for (Expression op : this.operands) {
            if (first) {
                first = false;
            } else {
                out.print(" ").print(this.operation.name()).print(" ");
            }
            op.print(out);
        }
        out.print(")");
    }

    @Override
    public void replace(HDLNet net, Expression expression) {
        for (int i = 0; i < this.operands.size(); ++i) {
            Expression op = this.operands.get(i);
            if (Expression.isVar(op, net)) {
                this.operands.set(i, expression);
                continue;
            }
            op.replace(net, expression);
        }
    }

    @Override
    public void traverse(Visitor visitor) {
        visitor.visit(this);
        for (Expression o : this.operands) {
            o.traverse(visitor);
        }
    }

    @Override
    public void optimize(ExpressionOptimizer eo) {
        for (int i = 0; i < this.operands.size(); ++i) {
            Expression expr = eo.optimize(this.operands.get(i));
            expr.optimize(eo);
            this.operands.set(i, expr);
        }
    }

    public static enum Operation {
        AND,
        OR,
        XOR;

    }
}

