/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2;

import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HasName;
import de.neemann.digital.hdl.model2.Printable;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.lang.Lang;
import java.io.IOException;

public class HDLPort
implements Printable,
HasName {
    private String name;
    private Direction direction;
    private int bits;
    private String description;
    private boolean isClock;
    private HDLNet net;
    private String pinNumber;
    private HDLNode parent;

    public HDLPort(String name, HDLNet net, Direction direction, int bits) throws HDLException {
        this.name = name.trim();
        if (this.name.length() == 0) {
            throw new HDLException(Lang.get("err_vhdlANameIsMissing", new Object[0]));
        }
        this.net = net;
        this.direction = direction;
        this.bits = bits;
        if (net != null) {
            net.addPort(this);
        }
    }

    public HDLPort setPinNumber(String pinNumber) {
        this.pinNumber = pinNumber;
        return this;
    }

    public HDLPort setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && this.description.trim().length() > 0;
    }

    public HDLNet getNet() {
        return this.net;
    }

    public void setNet(HDLNet net) throws HDLException {
        if (this.net != null) {
            this.net.remove(this);
        }
        this.net = net;
        if (net != null) {
            net.addPort(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String getPinNumber() {
        return this.pinNumber;
    }

    public void setIsClock() {
        this.isClock = true;
    }

    public boolean isClock() {
        return this.isClock;
    }

    public void setParent(HDLNode parent) {
        this.parent = parent;
    }

    public HDLNode getParent() {
        return this.parent;
    }

    public String toString() {
        return (Object)((Object)this.direction) + " " + this.name + "(" + this.bits + ")";
    }

    @Override
    public void print(CodePrinter out) throws IOException {
        out.print(this.name).print(":").print(this.bits);
        if (this.net != null) {
            if (this.net.getOutput() == this) {
                out.print(" defines (");
            } else {
                out.print(" reads (");
            }
            this.net.print(out);
            out.print(")");
        } else {
            out.print(" is not used");
        }
    }

    public void rename(HDLModel.Renaming renaming) {
        this.name = renaming.checkName(this.name);
    }

    public void setInOut() {
        this.direction = Direction.INOUT;
    }

    public static enum Direction {
        IN,
        OUT,
        INOUT;

    }
}

