/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2;

import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.HasName;
import de.neemann.digital.hdl.model2.Printable;
import de.neemann.digital.hdl.model2.expression.ExprConstant;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.util.ArrayList;

public class HDLNet
implements Printable,
HasName {
    private final boolean userNamed;
    private final ArrayList<HDLPort> inputs;
    private final ArrayList<HDLPort> inOutputs;
    private String name;
    private HDLPort output;
    private boolean needsVariable = true;
    private boolean isInput;

    public HDLNet(String name) {
        this.name = name;
        this.inputs = new ArrayList();
        this.inOutputs = new ArrayList();
        this.userNamed = name != null;
    }

    public boolean isUserNamed() {
        return this.userNamed;
    }

    public void addPort(HDLPort hdlPort) throws HDLException {
        switch (hdlPort.getDirection()) {
            case OUT: {
                if (this.output != null) {
                    String netName = this.name;
                    if (netName == null) {
                        netName = Lang.get("err_unnamedNet", new Object[0]);
                    }
                    throw new HDLException(Lang.get("err_hdlMultipleOutputsConnectedToNet_N_N_N", netName, this.output, hdlPort));
                }
                this.output = hdlPort;
                break;
            }
            case IN: {
                this.inputs.add(hdlPort);
                break;
            }
            case INOUT: {
                this.inOutputs.add(hdlPort);
            }
        }
    }

    public ArrayList<HDLPort> getInputs() {
        return this.inputs;
    }

    public HDLPort getOutput() {
        return this.output;
    }

    public String toString() {
        return this.name + " (" + this.output + " " + this.inputs + ")";
    }

    void fixBits() throws HDLException {
        int bits = 0;
        if (this.output == null) {
            if (this.inOutputs.isEmpty()) {
                throw new HDLException("no output connected to net");
            }
            for (HDLPort p : this.inOutputs) {
                if (p.getBits() <= 0) continue;
                bits = p.getBits();
                break;
            }
            if (bits == 0) {
                throw new HDLException("no bit number set for inOutputs " + this.inOutputs);
            }
        } else {
            bits = this.output.getBits();
            if (bits == 0) {
                throw new HDLException("no bit number set for output " + this.output.getName());
            }
        }
        for (HDLPort i : this.inputs) {
            i.setBits(bits);
        }
    }

    public ExprConstant isConstant() {
        if (this.output == null) {
            return null;
        }
        return ExprConstant.isConstant(this.output.getParent());
    }

    public void remove(HDLPort p) {
        if (p == this.output) {
            this.output = null;
        } else {
            this.inputs.remove(p);
        }
    }

    @Override
    public void print(CodePrinter out) throws IOException {
        out.print(this.name).print("->").print(this.inputs.size());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    void setIsInput(String name) {
        this.needsVariable = false;
        this.isInput = true;
        this.name = name;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public boolean needsVariable() {
        return this.needsVariable;
    }

    void setIsOutput(String name, boolean singleRead) {
        if (singleRead) {
            this.name = name;
            this.needsVariable = false;
        } else {
            this.name = name + "_temp";
        }
    }

    public int getBits() throws HDLException {
        if (this.output != null) {
            return this.output.getBits();
        }
        for (HDLPort p : this.inOutputs) {
            if (p.getBits() <= 0) continue;
            return p.getBits();
        }
        throw new HDLException("no bit number set for inOutputs " + this.inOutputs);
    }

    public boolean isClock() {
        if (this.output == null) {
            return false;
        }
        return this.output.isClock();
    }

    public void resetOutput() {
        this.output = null;
        this.name = null;
    }

    public void rename(HDLModel.Renaming renaming) {
        this.name = renaming.checkName(this.name);
    }

    public boolean isInOutNet() {
        return !this.inOutputs.isEmpty();
    }

    public void checkPinControlUsage() throws HDLException {
        if (this.output == null && this.inOutputs.size() > 0) {
            if (this.inputs.size() > 1) {
                throw new HDLException("multiple components connected to PinControl output");
            }
            if (this.inputs.size() == 1 && this.inputs.get(0).getParent() != null) {
                throw new HDLException("only a single output is allowed on a PinControl component");
            }
        }
    }
}

