/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.basic.Not;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.io.PowerSupply;
import de.neemann.digital.core.io.Probe;
import de.neemann.digital.core.wiring.Break;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Tunnel;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.GenericCode;
import de.neemann.digital.draw.library.GenericInitCode;
import de.neemann.digital.draw.model.Net;
import de.neemann.digital.draw.model.NetList;
import de.neemann.digital.gui.components.data.DummyElement;
import de.neemann.digital.gui.components.graphics.VGA;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLNodeAssignment;
import de.neemann.digital.hdl.model2.HDLNodeBuildIn;
import de.neemann.digital.hdl.model2.HDLNodeSplitterManyToOne;
import de.neemann.digital.hdl.model2.HDLNodeSplitterOneToMany;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.HasName;
import de.neemann.digital.hdl.model2.Printable;
import de.neemann.digital.hdl.model2.clock.ClockInfo;
import de.neemann.digital.hdl.model2.clock.HDLClockIntegrator;
import de.neemann.digital.hdl.model2.expression.ExprNot;
import de.neemann.digital.hdl.model2.expression.ExprVar;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.optimizations.InlineManyToOne;
import de.neemann.digital.hdl.model2.optimizations.MergeAssignments;
import de.neemann.digital.hdl.model2.optimizations.MergeConstants;
import de.neemann.digital.hdl.model2.optimizations.NameConstantSignals;
import de.neemann.digital.hdl.model2.optimizations.NodeSorterExpressionBased;
import de.neemann.digital.hdl.model2.optimizations.Optimization;
import de.neemann.digital.hdl.model2.optimizations.OptimizeExpressions;
import de.neemann.digital.hdl.model2.optimizations.RemoveConstantSignals;
import de.neemann.digital.hdl.model2.optimizations.ReplaceOneToMany;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class HDLCircuit
implements Iterable<HDLNode>,
HDLModel.BitProvider,
Printable {
    private final String elementName;
    private final int depth;
    private final ArrayList<HDLPort> outputs;
    private final ArrayList<HDLPort> inputs;
    private final ArrayList<HDLNet> listOfNets;
    private final String description;
    private final File origin;
    private final ArrayList<HDLNode> nodes;
    private final boolean skipHDL;
    private ArrayList<HDLPort> ports;
    private NetList netList;
    private HashMap<Net, HDLNet> nets;
    private String hdlEntityName;

    HDLCircuit(Circuit circuit, String elementName, HDLModel c, int depth) throws PinException, HDLException, NodeException {
        this(circuit, elementName, c, depth, null);
    }

    public HDLCircuit(Circuit circuit, String elementName, HDLModel c, int depth, HDLClockIntegrator clockIntegrator) throws PinException, HDLException, NodeException {
        this.elementName = elementName;
        this.depth = depth;
        this.hdlEntityName = elementName.toLowerCase().endsWith(".dig") ? elementName.substring(0, elementName.length() - 4) : elementName;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.nodes = new ArrayList();
        this.nets = new HashMap();
        this.listOfNets = new ArrayList();
        this.netList = new NetList(circuit);
        this.description = Lang.evalMultilingualContent(circuit.getAttributes().get(Keys.DESCRIPTION));
        this.origin = circuit.getOrigin();
        this.skipHDL = circuit.getAttributes().get(Keys.SKIP_HDL);
        ArrayList<ClockInfo> clocks = new ArrayList<ClockInfo>();
        try {
            for (VisualElement v : circuit.getElements()) {
                if (v.equalsDescription(In.DESCRIPTION) || v.equalsDescription(Clock.DESCRIPTION)) {
                    HDLPort port = new HDLPort(v.getElementAttributes().getLabel(), this.getNetOfPin(v.getPins().get(0)), HDLPort.Direction.OUT, v.getElementAttributes().getBits()).setPinNumber(v.getElementAttributes().get(Keys.PINNUMBER)).setDescription(Lang.evalMultilingualContent(v.getElementAttributes().get(Keys.DESCRIPTION)));
                    if (v.equalsDescription(Clock.DESCRIPTION)) {
                        clocks.add(new ClockInfo(port, v.getElementAttributes().get(Keys.FREQUENCY)));
                        port.setIsClock();
                    }
                    this.addInput(port);
                    continue;
                }
                if (v.equalsDescription(Out.DESCRIPTION)) {
                    this.addOutput(new HDLPort(v.getElementAttributes().getLabel(), this.getNetOfPin(v.getPins().get(0)), HDLPort.Direction.IN, v.getElementAttributes().getBits()).setPinNumber(v.getElementAttributes().get(Keys.PINNUMBER)).setDescription(Lang.evalMultilingualContent(v.getElementAttributes().get(Keys.DESCRIPTION))));
                    continue;
                }
                if (v.equalsDescription(Splitter.DESCRIPTION)) {
                    this.handleSplitter(c.createNode(v, this));
                    continue;
                }
                if (!this.isRealElement(v)) continue;
                this.nodes.add(c.createNode(v, this));
            }
        }
        catch (HDLException e) {
            throw new HDLException(Lang.get("err_errorAnalysingCircuit_N", circuit.getOrigin()), e);
        }
        this.netList = null;
        this.nets = null;
        if (clockIntegrator != null && !clocks.isEmpty()) {
            clockIntegrator.integrateClocks(this, clocks);
        }
        for (HDLNet n : this.listOfNets) {
            n.fixBits();
        }
        for (HDLNet n : this.listOfNets) {
            n.checkPinControlUsage();
        }
        for (HDLPort i : this.inputs) {
            if (i.getNet() == null) continue;
            i.getNet().setIsInput(i.getName());
            if (!i.getNet().isInOutNet()) continue;
            i.setInOut();
        }
        for (HDLPort o : this.outputs) {
            if (o.getNet().needsVariable()) {
                o.getNet().setIsOutput(o.getName(), o.getNet().getInputs().size() == 1);
            }
            if (!o.getNet().isInOutNet()) continue;
            o.setInOut();
        }
    }

    private void handleSplitter(HDLNode node) throws BitsException, HDLException {
        Splitter.Ports inputSplit = new Splitter.Ports(node.getElementAttributes().get(Keys.INPUT_SPLIT));
        Splitter.Ports outputSplit = new Splitter.Ports(node.getElementAttributes().get(Keys.OUTPUT_SPLIT));
        if (node.getInputs().size() == 1) {
            this.nodes.add(new HDLNodeSplitterOneToMany(node, outputSplit));
            return;
        }
        if (node.getOutputs().size() == 1 && node.getOutput().getBits() == inputSplit.getBits()) {
            this.nodes.add(new HDLNodeSplitterManyToOne(node, inputSplit));
            return;
        }
        int bits = inputSplit.getBits();
        HDLNet net = new HDLNet(null);
        this.listOfNets.add(net);
        HDLPort left = new HDLPort("single", net, HDLPort.Direction.OUT, bits);
        HDLPort right = new HDLPort("single", net, HDLPort.Direction.IN, bits);
        HDLNodeSplitterManyToOne manyToOne = new HDLNodeSplitterManyToOne(node, inputSplit);
        HDLNodeSplitterOneToMany oneToMany = new HDLNodeSplitterOneToMany(node, outputSplit);
        manyToOne.getOutputs().clear();
        manyToOne.addPort(left);
        oneToMany.getInputs().clear();
        oneToMany.addPort(right);
        this.nodes.add(manyToOne);
        this.nodes.add(oneToMany);
    }

    HDLNet createNot(HDLNet inNet) throws HDLException, NodeException, PinException {
        int bits = 1;
        ElementAttributes attr = new ElementAttributes().setBits(bits);
        HDLNodeAssignment n = new HDLNodeAssignment(Not.DESCRIPTION.getName(), attr, name -> bits);
        HDLNet outNet = new HDLNet(null);
        this.listOfNets.add(outNet);
        final HDLPort notOut = new HDLPort(((PinDescription)Not.DESCRIPTION.getOutputDescriptions(attr).get(0)).getName(), outNet, HDLPort.Direction.OUT, 0);
        n.addPort(notOut);
        n.addPort(new HDLPort(((PinDescription)Not.DESCRIPTION.getInputDescription(attr).get(0)).getName(), inNet, HDLPort.Direction.IN, 0){

            @Override
            public void setBits(int bits) {
                super.setBits(bits);
                notOut.setBits(bits);
            }
        });
        n.setExpression(new ExprNot(new ExprVar(inNet)));
        this.nodes.add(n);
        return outNet;
    }

    private void addOutput(HDLPort port) {
        this.outputs.add(port);
        this.ports = null;
    }

    private void addInput(HDLPort port) {
        this.inputs.add(port);
        this.ports = null;
    }

    private boolean isRealElement(VisualElement v) {
        return !v.equalsDescription(Tunnel.DESCRIPTION) && !v.equalsDescription(Break.DESCRIPTION) && !v.equalsDescription(Probe.DESCRIPTION) && !v.equalsDescription(VGA.DESCRIPTION) && !v.equalsDescription(PowerSupply.DESCRIPTION) && !v.equalsDescription(DummyElement.TEXTDESCRIPTION) && !v.equalsDescription(DummyElement.DATADESCRIPTION) && !v.equalsDescription(DummyElement.RECTDESCRIPTION) && !v.equalsDescription(TestCaseElement.DESCRIPTION) && !v.equalsDescription(GenericInitCode.DESCRIPTION) && !v.equalsDescription(GenericCode.DESCRIPTION);
    }

    HDLNet getNetOfPin(Pin pin) {
        Net n = this.netList.getNetOfPos(pin.getPos());
        if (n == null) {
            return null;
        }
        return this.nets.computeIfAbsent(n, net -> {
            HDLNet hdlNet = new HDLNet(this.createNetName((Net)net));
            this.listOfNets.add(hdlNet);
            return hdlNet;
        });
    }

    private String createNetName(Net net) {
        HashSet<String> labels = net.getLabels();
        if (labels.size() == 1) {
            return labels.iterator().next();
        }
        return null;
    }

    @Override
    public Iterator<HDLNode> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public int getBits(String name) {
        for (HDLPort o : this.outputs) {
            if (!o.getName().equals(name)) continue;
            return o.getBits();
        }
        return 0;
    }

    public String getElementName() {
        return this.elementName;
    }

    public ArrayList<HDLPort> getOutputs() {
        return this.outputs;
    }

    public ArrayList<HDLPort> getInputs() {
        return this.inputs;
    }

    public ArrayList<HDLPort> getPorts() {
        if (this.ports == null) {
            this.ports = new ArrayList();
            this.ports.addAll(this.inputs);
            this.ports.addAll(this.outputs);
        }
        return this.ports;
    }

    public String toString() {
        return "HDLCircuit{elementName='" + this.elementName + "'}";
    }

    public HDLCircuit nameUnnamedSignals(NetNaming netNaming) {
        for (HDLNet n : this.listOfNets) {
            if (n.getName() != null) continue;
            n.setName(netNaming.createName(n));
        }
        return this;
    }

    public HDLCircuit nameUnnamedSignals() {
        return this.nameUnnamedSignals(new DefaultNetNaming());
    }

    @Override
    public void print(CodePrinter out) throws IOException {
        out.print("circuit ").println(this.elementName).inc();
        out.print("in");
        this.printList(out, (Collection<? extends Printable>)this.inputs);
        out.print("out");
        this.printList(out, (Collection<? extends Printable>)this.outputs);
        out.print("sig");
        this.printList(out, this.listOfNets);
        out.println();
        for (HDLNode n : this.nodes) {
            out.print("node ").println(n.getElementName()).inc();
            n.print(out);
            out.dec();
        }
        out.println();
        for (HDLPort p : this.outputs) {
            HDLNet net = p.getNet();
            if (!net.needsVariable() && !net.isInput()) continue;
            p.print(out);
            out.print(" := ");
            net.print(out);
            out.println();
        }
        out.dec().print("end circuit ").println(this.elementName);
    }

    private void printList(CodePrinter out, Collection<? extends Printable> ports) throws IOException {
        boolean first = true;
        for (Printable printable : ports) {
            if (first) {
                first = false;
                out.print("(");
            } else {
                out.print(", ");
            }
            printable.print(out);
        }
        if (first) {
            out.print("(");
        }
        out.println(")");
    }

    private void printList(CodePrinter out, ArrayList<HDLNet> nets) throws IOException {
        boolean first = true;
        for (HDLNet net : nets) {
            if (!net.needsVariable()) continue;
            if (first) {
                first = false;
                out.print("(");
            } else {
                out.print(", ");
            }
            net.print(out);
        }
        if (first) {
            out.print("(");
        }
        out.println(")");
    }

    public void removeNet(HDLNet net) {
        this.listOfNets.remove(net);
    }

    public ArrayList<HDLNet> getNets() {
        return this.listOfNets;
    }

    public void rename(HDLModel.Renaming renaming) throws HDLException {
        try {
            for (HDLPort hDLPort : this.outputs) {
                hDLPort.rename(renaming);
            }
            for (HDLPort hDLPort : this.inputs) {
                hDLPort.rename(renaming);
            }
            for (HDLNet hDLNet : this.listOfNets) {
                hDLNet.rename(renaming);
            }
            for (HDLNode hDLNode : this.nodes) {
                hDLNode.rename(renaming);
            }
            this.hdlEntityName = renaming.checkName(this.hdlEntityName);
            this.checkUnique(this.getPorts());
            this.checkUnique(this.listOfNets);
        }
        catch (HDLException e) {
            e.setOrigin(this.origin);
            throw e;
        }
    }

    private void checkUnique(Collection<? extends HasName> names) throws HDLException {
        HashSet<String> set = new HashSet<String>();
        for (HasName hasName : names) {
            String name = hasName.getName();
            if (set.contains(name)) {
                throw new HDLException(Lang.get("err_namesAreNotUnique_N", name));
            }
            set.add(name);
        }
    }

    public String getHdlEntityName() {
        return this.hdlEntityName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && this.description.trim().length() > 0;
    }

    public boolean shouldSkipHDLExport() {
        return this.skipHDL;
    }

    public void integrateClockNode(HDLPort clock, HDLNodeBuildIn clockNode) throws HDLException {
        HDLNet outNet = clock.getNet();
        HDLNet inNet = new HDLNet(null);
        if (outNet == null) {
            throw new HDLException(Lang.get("err_clockIsNotUsed", new Object[0]));
        }
        outNet.resetOutput();
        clock.setNet(inNet);
        this.listOfNets.add(inNet);
        clockNode.addPort(new HDLPort("cout", outNet, HDLPort.Direction.OUT, 1)).addPort(new HDLPort("cin", inNet, HDLPort.Direction.IN, 1));
        clockNode.createExpressions();
        this.nodes.add(clockNode);
    }

    public ArrayList<HDLNode> getNodes() {
        return this.nodes;
    }

    public HDLCircuit apply(Optimization optimization) throws HDLException {
        try {
            optimization.optimize(this);
        }
        catch (HDLException e) {
            e.setOrigin(this.origin);
            throw e;
        }
        return this;
    }

    public HDLCircuit applyDefaultOptimizations() throws HDLException {
        this.apply(new ReplaceOneToMany());
        this.apply(new MergeAssignments());
        this.apply(new OptimizeExpressions(new ExprNot.OptimizeNotNot()));
        this.apply(new InlineManyToOne());
        this.apply(new RemoveConstantSignals());
        this.apply(new MergeConstants());
        this.apply(new NameConstantSignals());
        this.apply(new NodeSorterExpressionBased());
        return this.nameUnnamedSignals();
    }

    public void replaceNetByExpression(HDLNet net, Expression expression) {
        for (HDLNode n : this.nodes) {
            n.replaceNetByExpression(net, expression);
        }
    }

    public File getOrigin() {
        return this.origin;
    }

    public int getDepth() {
        return this.depth;
    }

    private final class DefaultNetNaming
    implements NetNaming {
        private final HashSet<String> map = new HashSet();
        private int num = 0;

        private DefaultNetNaming() {
            for (HDLPort p : HDLCircuit.this.inputs) {
                this.map.add(p.getName().toLowerCase());
            }
            for (HDLPort p : HDLCircuit.this.outputs) {
                this.map.add(p.getName().toLowerCase());
            }
            for (HDLNet n : HDLCircuit.this.listOfNets) {
                if (n.getName() == null) continue;
                this.map.add(n.getName().toLowerCase());
            }
        }

        @Override
        public String createName(HDLNet n) {
            String name;
            while (this.isDuplicate(name = "s" + this.num++)) {
            }
            return name;
        }

        private boolean isDuplicate(String name) {
            return this.map.contains(name.toLowerCase());
        }
    }

    public static interface NetNaming {
        public String createName(HDLNet var1);
    }
}

