/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.hgs;

import de.neemann.digital.core.Bits;
import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.Expression;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.ParserException;
import de.neemann.digital.hdl.hgs.Statement;
import de.neemann.digital.hdl.hgs.Statements;
import de.neemann.digital.hdl.hgs.Tokenizer;
import de.neemann.digital.hdl.hgs.Value;
import de.neemann.digital.hdl.hgs.function.FirstClassFunction;
import de.neemann.digital.hdl.hgs.function.FirstClassFunctionCall;
import de.neemann.digital.hdl.hgs.refs.Reference;
import de.neemann.digital.hdl.hgs.refs.ReferenceToArray;
import de.neemann.digital.hdl.hgs.refs.ReferenceToFunc;
import de.neemann.digital.hdl.hgs.refs.ReferenceToStruct;
import de.neemann.digital.hdl.hgs.refs.ReferenceToVar;
import de.neemann.digital.testing.parser.OperatorPrecedence;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Parser {
    private ArrayList<Reference> refRead;
    private final Tokenizer tok;

    public static Statement createFromJar(String path, ClassLoader cl) throws IOException, ParserException {
        InputStream in;
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((in = cl.getResourceAsStream(path)) == null) {
            throw new FileNotFoundException("file not found: " + path);
        }
        try (InputStreamReader r = new InputStreamReader(in, StandardCharsets.UTF_8);){
            Parser p = new Parser(r, path);
            Statement statement = p.parse();
            return statement;
        }
    }

    public static Statement createFromJarStatic(String path) {
        try {
            return Parser.createFromJar(path, null);
        }
        catch (ParserException | IOException e) {
            throw new RuntimeException("could not parse: " + path, e);
        }
    }

    public Parser(String code) {
        this(new StringReader(code), "");
    }

    public Parser(Reader reader, String srcFile) {
        this.tok = new Tokenizer(reader, srcFile);
    }

    public void enableRefReadCollection() {
        this.refRead = new ArrayList();
    }

    public ArrayList<Reference> getRefsRead() {
        return this.refRead;
    }

    private Statement lino(Statement statement) {
        if (statement instanceof StatementWithLine) {
            return statement;
        }
        return new StatementWithLine(statement, this.tok.getLine());
    }

    private Expression linoE(Expression expression) {
        if (expression instanceof ExpressionWithLine) {
            return expression;
        }
        return new ExpressionWithLine(expression, this.tok.getLine());
    }

    public Statement parse() throws IOException, ParserException {
        return this.parse(true);
    }

    public Statement parse(boolean startsWithText) throws IOException, ParserException {
        Statements s = new Statements();
        if (startsWithText) {
            String text = this.tok.readText();
            if (this.nextIs(Tokenizer.Token.SUB)) {
                text = Value.trimRight(text);
            }
            if (text.length() > 0) {
                String t = text;
                s.add(c -> c.print(t));
            }
        }
        while (!this.nextIs(Tokenizer.Token.EOF)) {
            s.add(this.parseStatement());
        }
        return s.optimize();
    }

    private Statement parseStatement() throws IOException, ParserException {
        return this.parseStatement(true);
    }

    private Statement parseStatement(boolean isRealStatement) throws IOException, ParserException {
        Tokenizer.Token token = this.tok.next();
        boolean export = false;
        switch (token) {
            case EXPORT: {
                export = true;
                Tokenizer.Token ti = this.tok.next();
                if (!ti.equals((Object)Tokenizer.Token.IDENT)) {
                    throw this.newParserException("export must be followed by an identifier!");
                }
            }
            case IDENT: {
                Reference ref = this.parseReference(this.tok.getIdent());
                Tokenizer.Token refToken = this.tok.next();
                switch (refToken) {
                    case COLON: {
                        this.expect(Tokenizer.Token.EQUAL);
                        Expression initVal = this.parseExpression();
                        if (isRealStatement) {
                            this.expect(Tokenizer.Token.SEMICOLON);
                        }
                        if (export) {
                            return this.lino(c -> ref.exportVar(c, initVal.value(c)));
                        }
                        return this.lino(c -> ref.declareVar(c, initVal.value(c)));
                    }
                    case EQUAL: {
                        if (export) {
                            throw this.newParserException("export is only allowed at variable declaration!");
                        }
                        Expression val = this.parseExpression();
                        if (isRealStatement) {
                            this.expect(Tokenizer.Token.SEMICOLON);
                        }
                        return this.lino(c -> {
                            Object value = val.value(c);
                            if (value == null) {
                                throw new HGSEvalException("There is no value to assign!");
                            }
                            ref.set(c, value);
                        });
                    }
                    case ADD: {
                        this.expect(Tokenizer.Token.ADD);
                        if (export) {
                            throw this.newParserException("export is only allowed at variable declaration!");
                        }
                        if (isRealStatement) {
                            this.expect(Tokenizer.Token.SEMICOLON);
                        }
                        return this.lino(c -> ref.set(c, Value.toLong(ref.get(c)) + 1L));
                    }
                    case SUB: {
                        this.expect(Tokenizer.Token.SUB);
                        if (export) {
                            throw this.newParserException("export is only allowed at variable declaration!");
                        }
                        if (isRealStatement) {
                            this.expect(Tokenizer.Token.SEMICOLON);
                        }
                        return this.lino(c -> ref.set(c, Value.toLong(ref.get(c)) - 1L));
                    }
                    case SEMICOLON: {
                        if (export) {
                            throw this.newParserException("export is only allowed at variable declaration!");
                        }
                        return this.lino(ref::get);
                    }
                }
                throw this.newUnexpectedToken(refToken);
            }
            case CODEEND: {
                String str = this.tok.readText();
                if (this.nextIs(Tokenizer.Token.SUB)) {
                    str = Value.trimRight(str);
                }
                String strc = str;
                return c -> c.print(strc);
            }
            case SUB: {
                this.expect(Tokenizer.Token.CODEEND);
                String strt = Value.trimLeft(this.tok.readText());
                return c -> c.print(strt);
            }
            case EQUAL: {
                Expression exp = this.parseExpression();
                if (this.tok.peek() != Tokenizer.Token.CODEEND) {
                    this.expect(Tokenizer.Token.SEMICOLON);
                }
                return this.lino(c -> c.print(exp.value(c).toString()));
            }
            case IF: {
                this.expect(Tokenizer.Token.OPEN);
                Expression ifCond = this.toBool(this.parseExpression());
                this.expect(Tokenizer.Token.CLOSE);
                Statement ifStatement = this.parseStatement();
                if (this.nextIs(Tokenizer.Token.ELSE)) {
                    Statement elseStatement = this.parseStatement();
                    return c -> {
                        Context iC = new Context(c, false);
                        if (((Boolean)ifCond.value(iC)).booleanValue()) {
                            ifStatement.execute(iC);
                        } else {
                            elseStatement.execute(iC);
                        }
                    };
                }
                return c -> {
                    Context iC = new Context(c, false);
                    if (((Boolean)ifCond.value(iC)).booleanValue()) {
                        ifStatement.execute(iC);
                    }
                };
            }
            case FOR: {
                this.expect(Tokenizer.Token.OPEN);
                Statement init = this.parseStatement(false);
                this.expect(Tokenizer.Token.SEMICOLON);
                Expression forCond = this.toBool(this.parseExpression());
                this.expect(Tokenizer.Token.SEMICOLON);
                Statement inc = this.parseStatement(false);
                this.expect(Tokenizer.Token.CLOSE);
                Statement inner = this.parseStatement();
                return c -> {
                    Context iC = new Context(c, false);
                    init.execute(iC);
                    while (((Boolean)forCond.value(iC)).booleanValue()) {
                        inner.execute(new Context(iC, false));
                        inc.execute(iC);
                    }
                };
            }
            case WHILE: {
                this.expect(Tokenizer.Token.OPEN);
                Expression whileCond = this.toBool(this.parseExpression());
                this.expect(Tokenizer.Token.CLOSE);
                Statement inner = this.parseStatement();
                return c -> {
                    Context iC = new Context(c, false);
                    while (((Boolean)whileCond.value(iC)).booleanValue()) {
                        inner.execute(iC);
                    }
                };
            }
            case REPEAT: {
                Statement repeatInner = this.parseStatement();
                this.expect(Tokenizer.Token.UNTIL);
                Expression repeatCond = this.toBool(this.parseExpression());
                if (isRealStatement) {
                    this.expect(Tokenizer.Token.SEMICOLON);
                }
                return c -> {
                    Context iC = new Context(c, false);
                    do {
                        repeatInner.execute(iC);
                    } while (!((Boolean)repeatCond.value(iC)).booleanValue());
                };
            }
            case OPENBRACE: {
                Statements s = new Statements();
                while (!this.nextIs(Tokenizer.Token.CLOSEDBRACE)) {
                    s.add(this.parseStatement());
                }
                return s.optimize();
            }
            case RETURN: {
                Expression retExp = this.parseExpression();
                this.expect(Tokenizer.Token.SEMICOLON);
                return this.lino(c -> FirstClassFunctionCall.returnFromFunc(retExp.value(c)));
            }
            case FUNC: {
                this.expect(Tokenizer.Token.IDENT);
                String funcName = this.tok.getIdent();
                FirstClassFunction funcDecl = this.parseFunction();
                return this.lino(c -> c.declareVar(funcName, new FirstClassFunctionCall(funcDecl, c)));
            }
        }
        throw this.newUnexpectedToken(token);
    }

    private Expression toBool(Expression expression) {
        return this.linoE(c -> Value.toBool(expression.value(c)));
    }

    private ArrayList<Expression> parseArgList() throws IOException, ParserException {
        ArrayList<Expression> args = new ArrayList<Expression>();
        if (!this.nextIs(Tokenizer.Token.CLOSE)) {
            args.add(this.parseExpression());
            while (this.nextIs(Tokenizer.Token.COMMA)) {
                args.add(this.parseExpression());
            }
            this.expect(Tokenizer.Token.CLOSE);
        }
        return args;
    }

    private Reference parseReference(String var) throws IOException, ParserException {
        Reference r = new ReferenceToVar(var);
        while (true) {
            if (this.nextIs(Tokenizer.Token.OPENSQUARE)) {
                r = new ReferenceToArray(r, this.parseExpression());
                this.expect(Tokenizer.Token.CLOSEDSQUARE);
                continue;
            }
            if (this.nextIs(Tokenizer.Token.OPEN)) {
                r = new ReferenceToFunc(r, this.parseArgList());
                continue;
            }
            if (!this.nextIs(Tokenizer.Token.DOT)) break;
            this.expect(Tokenizer.Token.IDENT);
            r = new ReferenceToStruct(r, this.tok.getIdent());
        }
        return r;
    }

    private boolean nextIs(Tokenizer.Token t) throws IOException {
        if (this.tok.peek() == t) {
            this.tok.next();
            return true;
        }
        return false;
    }

    private void expect(Tokenizer.Token token) throws IOException, ParserException {
        Tokenizer.Token t = this.tok.next();
        if (t != token) {
            throw this.newParserException("expected: " + (Object)((Object)token) + ", but found: " + (Object)((Object)t));
        }
    }

    private long convToLong(String num) throws ParserException {
        try {
            return Bits.decode(num);
        }
        catch (Bits.NumberFormatException e) {
            throw this.newParserException("not a number: " + this.tok.getIdent());
        }
    }

    private double convToDouble(String num) throws ParserException {
        try {
            return Double.parseDouble(num);
        }
        catch (NumberFormatException e) {
            throw this.newParserException("not a number: " + this.tok.getIdent());
        }
    }

    private ParserException newUnexpectedToken(Tokenizer.Token token) {
        String name = token == Tokenizer.Token.IDENT ? this.tok.getIdent() : token.name();
        return this.newParserException("unexpected Token: " + name);
    }

    private ParserException newParserException(String s) {
        return new ParserException(s + " (" + this.tok.getSrcFile() + ":" + this.tok.getLine() + ")");
    }

    public Expression parseExp() throws IOException, ParserException {
        Expression ex = this.parseExpression();
        this.expect(Tokenizer.Token.EOF);
        return ex;
    }

    private Expression parseExpression() throws IOException, ParserException {
        return this.parseExpression(OperatorPrecedence.lowest());
    }

    private Expression parseExpression(OperatorPrecedence op) throws IOException, ParserException {
        Next next = this.getNextParser(op.getNextHigherPrecedence());
        Expression ac = next.next();
        while (this.tok.peek().getPrecedence() == op) {
            Tokenizer.Binary function = this.tok.next().getBinary();
            Expression a = ac;
            Expression b = next.next();
            ac = c -> function.op(a.value(c), b.value(c));
        }
        return ac;
    }

    private Next getNextParser(OperatorPrecedence pr) {
        if (pr == null) {
            return this::parseIdent;
        }
        return () -> this.parseExpression(pr);
    }

    private Expression parseIdent() throws IOException, ParserException {
        Tokenizer.Token t = this.tok.next();
        switch (t) {
            case IDENT: {
                String name = this.tok.getIdent();
                Reference r = this.parseReference(name);
                if (this.refRead != null) {
                    this.refRead.add(r);
                }
                return r::get;
            }
            case NUMBER: {
                long num = this.convToLong(this.tok.getIdent());
                return c -> num;
            }
            case DOUBLE: {
                double d = this.convToDouble(this.tok.getIdent());
                return c -> d;
            }
            case TRUE: {
                return c -> true;
            }
            case FALSE: {
                return c -> false;
            }
            case STRING: {
                String s = this.tok.getIdent();
                return c -> s;
            }
            case SUB: {
                Expression negExp = this.parseIdent();
                return c -> Value.neg(negExp.value(c));
            }
            case NOT: {
                Expression notExp = this.parseIdent();
                return c -> Value.not(notExp.value(c));
            }
            case OPEN: {
                Expression exp = this.parseExpression();
                this.expect(Tokenizer.Token.CLOSE);
                return exp;
            }
            case OPENBRACE: {
                return this.parseStructLiteral();
            }
            case OPENSQUARE: {
                return this.parseListLiteral();
            }
            case FUNC: {
                FirstClassFunction func = this.parseFunction();
                return c -> new FirstClassFunctionCall(func, c);
            }
        }
        throw this.newUnexpectedToken(t);
    }

    private Expression parseListLiteral() throws IOException, ParserException {
        ArrayList<Expression> al = new ArrayList<Expression>();
        while (true) {
            if (this.tok.peek() == Tokenizer.Token.CLOSEDSQUARE) {
                this.tok.consume();
                return c -> {
                    ArrayList<Object> l = new ArrayList<Object>();
                    for (Expression e : al) {
                        l.add(e.value(c));
                    }
                    return l;
                };
            }
            al.add(this.parseExpression());
            if (this.tok.peek() != Tokenizer.Token.COMMA) continue;
            this.tok.consume();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression parseStructLiteral() throws IOException, ParserException {
        Tokenizer.Token t;
        StructLiteral sl = new StructLiteral();
        block4: while (true) {
            t = this.tok.next();
            switch (t) {
                case CLOSEDBRACE: {
                    return sl;
                }
                case IDENT: {
                    String key = this.tok.getIdent();
                    this.expect(Tokenizer.Token.COLON);
                    Expression exp = this.parseExpression();
                    sl.add(key, exp);
                    if (this.nextIs(Tokenizer.Token.COMMA)) {
                        this.tok.consume();
                        continue block4;
                    }
                    if (this.tok.peek() != Tokenizer.Token.CLOSEDBRACE) throw this.newUnexpectedToken(t);
                    continue block4;
                }
            }
            break;
        }
        throw this.newUnexpectedToken(t);
    }

    private FirstClassFunction parseFunction() throws IOException, ParserException {
        this.expect(Tokenizer.Token.OPEN);
        ArrayList<String> args = new ArrayList<String>();
        if (!this.nextIs(Tokenizer.Token.CLOSE)) {
            this.expect(Tokenizer.Token.IDENT);
            args.add(this.tok.getIdent());
            while (!this.nextIs(Tokenizer.Token.CLOSE)) {
                this.expect(Tokenizer.Token.COMMA);
                this.expect(Tokenizer.Token.IDENT);
                args.add(this.tok.getIdent());
            }
        }
        Statement st = this.parseStatement();
        return new FirstClassFunction(args, st);
    }

    private static final class StructLiteral
    implements Expression {
        private final HashMap<String, Expression> map = new HashMap();

        private StructLiteral() {
        }

        private void add(String key, Expression exp) {
            this.map.put(key, exp);
        }

        @Override
        public Object value(Context c) throws HGSEvalException {
            HashMap<String, Object> vmap = new HashMap<String, Object>();
            for (Map.Entry<String, Expression> e : this.map.entrySet()) {
                vmap.put(e.getKey(), e.getValue().value(c));
            }
            return vmap;
        }
    }

    private static final class ExpressionWithLine
    implements Expression {
        private final Expression expression;
        private final int line;

        private ExpressionWithLine(Expression expression, int line) {
            this.expression = expression;
            this.line = line;
        }

        @Override
        public Object value(Context c) throws HGSEvalException {
            try {
                return this.expression.value(c);
            }
            catch (HGSEvalException e) {
                e.setLinNum(this.line);
                throw e;
            }
        }
    }

    private static final class StatementWithLine
    implements Statement {
        private final Statement statement;
        private final int line;

        private StatementWithLine(Statement statement, int line) {
            this.statement = statement;
            this.line = line;
        }

        @Override
        public void execute(Context context) throws HGSEvalException {
            try {
                this.statement.execute(context);
            }
            catch (HGSEvalException e) {
                e.setLinNum(this.line);
                throw e;
            }
        }
    }

    private static interface Next {
        public Expression next() throws IOException, ParserException;
    }
}

