/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.hgs;

import de.neemann.digital.FileLocator;
import de.neemann.digital.core.Bits;
import de.neemann.digital.core.extern.Application;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.importer.Importer;
import de.neemann.digital.hdl.hgs.Expression;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.HGSMap;
import de.neemann.digital.hdl.hgs.Value;
import de.neemann.digital.hdl.hgs.function.Func;
import de.neemann.digital.hdl.hgs.function.Function;
import de.neemann.digital.hdl.hgs.function.InnerFunction;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context
implements HGSMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(Context.class);
    private static final HashMap<String, InnerFunction> BUILT_IN = new HashMap();
    public static final String BASE_FILE_KEY = "baseFile";
    private final Context parent;
    private final StringBuilder code;
    private final HashMap<String, Object> map;
    private File rootPath;
    private boolean loggingEnabled = true;

    public Context(File rootPath) {
        this(null, true);
        this.rootPath = rootPath;
    }

    public Context(Context parent) {
        this(parent, true);
    }

    public Context(Context parent, boolean enablePrint) {
        this.parent = parent;
        this.code = enablePrint ? new StringBuilder() : null;
        this.map = new HashMap();
    }

    public boolean contains(String name) {
        if (this.map.containsKey(name)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.contains(name);
        }
        return false;
    }

    public File getRootPath() {
        if (this.parent != null) {
            return this.parent.getRootPath();
        }
        return this.rootPath;
    }

    public void setRootPath(File rootPath) {
        this.rootPath = rootPath;
    }

    public Object getVar(String name) throws HGSEvalException {
        Object v = this.map.get(name);
        if (v == null) {
            if (this.parent == null) {
                InnerFunction builtIn = BUILT_IN.get(name);
                if (builtIn != null) {
                    return builtIn;
                }
                throw new HGSEvalException("Variable not found: " + name);
            }
            return this.parent.getVar(name);
        }
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setVar(String name, Object val) throws HGSEvalException {
        Object v = this.map.get(name);
        if (v != null) {
            if (!v.getClass().isAssignableFrom(val.getClass())) throw new HGSEvalException("Variable '" + name + "' has wrong type. Needs to be " + v.getClass().getSimpleName() + ", is " + val.getClass().getSimpleName());
            this.map.put(name, val);
            return;
        } else {
            if (this.parent == null) throw new HGSEvalException("Variable '" + name + "' not declared!");
            this.parent.setVar(name, val);
        }
    }

    public Context exportVar(String name, Object value) throws HGSEvalException {
        if (this.parent == null) {
            this.declareVar(name, value);
        } else {
            this.parent.exportVar(name, value);
        }
        return this;
    }

    public Context declareVar(String name, Object value) throws HGSEvalException {
        if (this.map.containsKey(name)) {
            throw new HGSEvalException("Variable '" + name + "' already declared!");
        }
        this.map.put(name, value);
        return this;
    }

    public Context declareFunc(String name, InnerFunction func) throws HGSEvalException {
        return this.declareVar(name, func);
    }

    public Context print(String str) {
        if (this.code != null) {
            this.code.append(str);
        } else {
            this.parent.print(str);
        }
        return this;
    }

    public String toString() {
        if (this.code != null) {
            return this.code.toString();
        }
        return this.parent.toString();
    }

    public String toStringKeys() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> k : this.map.entrySet()) {
            sb.append(k.getKey()).append(":");
            Object val = k.getValue();
            if (val instanceof Context) {
                sb.append("[").append(((Context)val).toStringKeys()).append("]");
            } else if (val instanceof File) {
                sb.append(".../").append(((File)val).getName());
            } else {
                sb.append(val.toString());
            }
            sb.append("; ");
        }
        return sb.toString();
    }

    public void clearOutput() {
        if (this.code != null) {
            this.code.setLength(0);
        } else {
            this.parent.clearOutput();
        }
    }

    private void log(Object o) {
        if (this.loggingEnabled) {
            if (this.parent != null) {
                this.parent.log(o);
            } else {
                LOGGER.info(o.toString());
            }
        }
    }

    public int length() {
        if (this.code != null) {
            return this.code.length();
        }
        return this.parent.length();
    }

    public Context disableLogging() {
        this.loggingEnabled = false;
        return this;
    }

    public Function getFunction(String funcName) throws HGSEvalException {
        Object fObj = this.getVar(funcName);
        if (fObj instanceof Function) {
            return (Function)fObj;
        }
        throw new HGSEvalException("Variable '" + funcName + "' is not a function");
    }

    @Override
    public Object hgsMapGet(String key) {
        return this.map.get(key);
    }

    public HashSet<String> getKeySet() {
        return new HashSet<String>(this.map.keySet());
    }

    private static String format(Context c, ArrayList<Expression> args) throws HGSEvalException {
        if (args.size() < 2) {
            throw new HGSEvalException("format/printf needs at least two arguments!");
        }
        ArrayList<Object> eval = new ArrayList<Object>(args.size() - 1);
        for (int i = 1; i < args.size(); ++i) {
            eval.add(args.get(i).value(c));
        }
        return String.format(Locale.US, Value.toString(args.get(0).value(c)), eval.toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return Objects.equals(this.parent, context.parent) && this.map.equals(context.map);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.map);
    }

    static {
        BUILT_IN.put("bitsNeededFor", new FunctionBitsNeeded());
        BUILT_IN.put("ceil", new FunctionCeil());
        BUILT_IN.put("floor", new FunctionFloor());
        BUILT_IN.put("round", new FunctionRound());
        BUILT_IN.put("random", new FunctionRandom());
        BUILT_IN.put("float", new FunctionFloat());
        BUILT_IN.put("int", new FunctionInt());
        BUILT_IN.put("min", new FunctionMin());
        BUILT_IN.put("max", new FunctionMax());
        BUILT_IN.put("abs", new FunctionAbs());
        BUILT_IN.put("print", new FunctionPrint());
        BUILT_IN.put("printf", new FunctionPrintf());
        BUILT_IN.put("println", new FunctionPrintln());
        BUILT_IN.put("log", new FunctionLog());
        BUILT_IN.put("format", new FunctionFormat());
        BUILT_IN.put("isPresent", new FunctionIsPresent());
        BUILT_IN.put("panic", new FunctionPanic());
        BUILT_IN.put("output", new FunctionOutput());
        BUILT_IN.put("splitString", new FunctionSplitString());
        BUILT_IN.put("identifier", new FunctionIdentifier());
        BUILT_IN.put("loadHex", new FunctionLoadHex());
        BUILT_IN.put("loadFile", new FunctionLoadFile());
        BUILT_IN.put("sizeOf", new Func(1, args -> Value.toArray(args[0]).hgsArraySize()));
        BUILT_IN.put("startsWith", new Func(2, args -> args[0].toString().startsWith(args[1].toString())));
    }

    private static final class FunctionLoadFile
    extends InnerFunction {
        private FunctionLoadFile() {
            super(1);
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) throws HGSEvalException {
            File f = new File(args.get(0).value(c).toString());
            f = new FileLocator(f).setLibraryRoot(c.getRootPath()).locate();
            try {
                return Application.readCode(f);
            }
            catch (IOException e) {
                throw new HGSEvalException("error reading the file " + f.getPath(), e);
            }
        }
    }

    private static final class FunctionLoadHex
    extends InnerFunction {
        private FunctionLoadHex() {
            super(-1);
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) throws HGSEvalException {
            File hexFile;
            File name = new File(args.get(0).value(c).toString());
            int dataBits = Value.toInt(args.get(1).value(c));
            boolean bigEndian = false;
            if (args.size() > 2) {
                bigEndian = Value.toBool(args.get(2).value(c));
            }
            if ((hexFile = new FileLocator(name).setLibraryRoot(c.getRootPath()).locate()) == null || !hexFile.exists()) {
                throw new HGSEvalException("File " + name + " not found! Is circuit saved?");
            }
            try {
                DataField dataField = Importer.read(hexFile, dataBits, bigEndian);
                dataField.trim();
                return dataField;
            }
            catch (IOException e) {
                throw new HGSEvalException("error reading the file " + hexFile.getPath(), e);
            }
        }
    }

    private static final class FunctionMax
    extends Function {
        private FunctionMax() {
            super(-1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            long maxL = Long.MIN_VALUE;
            double maxD = -1.7976931348623157E308;
            for (Object v : args) {
                if (v instanceof Double) {
                    double l = (Double)v;
                    if (!(maxD < l)) continue;
                    maxD = l;
                    continue;
                }
                long l = Value.toLong(v);
                if (maxL >= l) continue;
                maxL = l;
            }
            if (maxD > -1.7976931348623157E308 && maxL > Long.MIN_VALUE) {
                return Math.max(maxD, (double)maxL);
            }
            if (maxD > -1.7976931348623157E308) {
                return maxD;
            }
            return maxL;
        }
    }

    private static final class FunctionMin
    extends Function {
        private FunctionMin() {
            super(-1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            long minL = Long.MAX_VALUE;
            double minD = Double.MAX_VALUE;
            for (Object v : args) {
                if (v instanceof Double) {
                    double l = (Double)v;
                    if (!(minD > l)) continue;
                    minD = l;
                    continue;
                }
                long l = Value.toLong(v);
                if (minL <= l) continue;
                minL = l;
            }
            if (minD < Double.MAX_VALUE && minL < Long.MAX_VALUE) {
                return Math.min(minD, (double)minL);
            }
            if (minD < Double.MAX_VALUE) {
                return minD;
            }
            return minL;
        }
    }

    private static final class FunctionLog
    extends InnerFunction {
        private FunctionLog() {
            super(1);
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) throws HGSEvalException {
            if (args.size() != 1) {
                throw new HGSEvalException("wrong number of arguments! found: " + args.size() + ", expected: " + this.getArgCount());
            }
            Object v = args.get(0).value(c);
            c.log(v);
            return v;
        }
    }

    private static final class FunctionIdentifier
    extends Function {
        private FunctionIdentifier() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) {
            String str = args[0].toString();
            StringBuilder sb = new StringBuilder(str.length());
            for (int p = 0; p < str.length(); ++p) {
                char c = str.charAt(p);
                if (c >= '0' && c <= '9') {
                    if (sb.length() == 0) {
                        sb.append('n');
                    }
                    sb.append(c);
                    continue;
                }
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && c != '_') continue;
                sb.append(c);
            }
            return sb.toString();
        }
    }

    private static final class FunctionSplitString
    extends Function {
        private FunctionSplitString() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) {
            StringTokenizer st = new StringTokenizer(args[0].toString(), " \r\t\n,:;");
            ArrayList<String> list = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            return list;
        }
    }

    private static final class FunctionAbs
    extends Function {
        private FunctionAbs() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            if (args[0] instanceof Double) {
                return Math.abs((Double)args[0]);
            }
            return Math.abs(Value.toLong(args[0]));
        }
    }

    private static final class FunctionBitsNeeded
    extends Function {
        private FunctionBitsNeeded() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            return Bits.binLn2(Value.toLong(args[0]));
        }
    }

    private static final class FunctionInt
    extends Function {
        private FunctionInt() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            return Value.toInt(args[0]);
        }
    }

    private static final class FunctionFloat
    extends Function {
        private FunctionFloat() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            return Value.toDouble(args[0]);
        }
    }

    private static final class FunctionRandom
    extends Function {
        private final Random rand = new Random();

        private FunctionRandom() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            int bound = Value.toInt(args[0]);
            return new Long(this.rand.nextInt(bound));
        }
    }

    private static final class FunctionRound
    extends Function {
        private FunctionRound() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            if (args[0] instanceof Double) {
                return Math.round((Double)args[0]);
            }
            return Value.toLong(args[0]);
        }
    }

    private static final class FunctionFloor
    extends Function {
        private FunctionFloor() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            if (args[0] instanceof Double) {
                return (long)Math.floor((Double)args[0]);
            }
            return Value.toLong(args[0]);
        }
    }

    private static final class FunctionCeil
    extends Function {
        private FunctionCeil() {
            super(1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            if (args[0] instanceof Double) {
                return (long)Math.ceil((Double)args[0]);
            }
            return Value.toLong(args[0]);
        }
    }

    private static final class FunctionOutput
    extends InnerFunction {
        private FunctionOutput() {
            super(0);
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) {
            return c.toString();
        }
    }

    private static final class FunctionPanic
    extends Function {
        private FunctionPanic() {
            super(-1);
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            if (args.length == 0) {
                throw new HGSEvalException("panic");
            }
            String message = args[0].toString();
            if (message.startsWith("err_")) {
                if (args.length == 1) {
                    message = Lang.get(message, new Object[0]);
                } else {
                    Object[] ar = new String[args.length - 1];
                    for (int i = 0; i < args.length - 1; ++i) {
                        ar[i] = args[i + 1].toString();
                    }
                    message = Lang.get(message, ar);
                }
            }
            throw new HGSEvalException(message);
        }
    }

    private static final class FunctionIsPresent
    extends InnerFunction {
        private FunctionIsPresent() {
            super(1);
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) {
            try {
                args.get(0).value(c);
                return true;
            }
            catch (HGSEvalException e) {
                return false;
            }
        }
    }

    private static final class FunctionFormat
    extends InnerFunction {
        private FunctionFormat() {
            super(-1);
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) throws HGSEvalException {
            return Context.format(c, args);
        }
    }

    private static final class FunctionPrintf
    extends InnerFunction {
        private FunctionPrintf() {
            super(-1);
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) throws HGSEvalException {
            c.print(Context.format(c, args));
            return null;
        }
    }

    private static final class FunctionPrintln
    extends InnerFunction {
        private FunctionPrintln() {
            super(-1);
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) throws HGSEvalException {
            for (Expression arg : args) {
                c.print(arg.value(c).toString());
            }
            c.print(System.lineSeparator());
            return null;
        }
    }

    private static final class FunctionPrint
    extends InnerFunction {
        private FunctionPrint() {
            super(-1);
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) throws HGSEvalException {
            for (Expression arg : args) {
                c.print(arg.value(c).toString());
            }
            return null;
        }
    }
}

