/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.tutorial;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.basic.XOr;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.modification.ModifyInsertWire;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.undo.Modification;
import de.neemann.digital.undo.Modifications;
import de.neemann.gui.LineBreaker;
import de.neemann.gui.Screen;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class InitialTutorial
extends JDialog
implements CircuitComponent.TutorialListener,
ModelStateObserverTyped {
    private static final ArrayList<Step> STEPS = new ArrayList();
    private final Main main;
    private final JTextPane text;
    private final CircuitComponent circuitComponent;
    private int stepIndex;

    private static boolean outputIsHigh(InitialTutorial t) {
        Model model = t.main.getModel();
        if (model == null) {
            return false;
        }
        List<Node> nl = model.getNodes();
        if (nl.size() != 1) {
            return false;
        }
        Node n = nl.get(0);
        if (n instanceof Element) {
            Element e = (Element)((Object)n);
            try {
                ObservableValues outputs = e.getOutputs();
                if (outputs.size() != 1) {
                    return false;
                }
                return ((ObservableValue)outputs.get(0)).getValue() != 0L;
            }
            catch (PinException ex) {
                return false;
            }
        }
        return false;
    }

    private static boolean isIONamed(CircuitComponent cc, int expected, InitialTutorial t) {
        HashSet<String> set = new HashSet<String>();
        int num = 0;
        for (VisualElement ve : cc.getCircuit().getElements()) {
            String l;
            if (!ve.equalsDescription(In.DESCRIPTION) && !ve.equalsDescription(Out.DESCRIPTION) || (l = ve.getElementAttributes().getLabel()).isEmpty()) continue;
            if (set.contains(l)) {
                t.setTextByID("tutorialUniqueIdents");
                return false;
            }
            set.add(l);
            ++num;
        }
        return num >= expected;
    }

    private static boolean isWorking(CircuitComponent cc) {
        if (cc.getCircuit().getElements().size() < 4) {
            return false;
        }
        try {
            new ModelCreator(cc.getCircuit(), cc.getLibrary()).createModel(false);
            return true;
        }
        catch (NodeException | PinException | ElementNotFoundException e) {
            return false;
        }
    }

    private static boolean contains(Modification<Circuit> mod, Class<? extends Modification> modifyClass) {
        if (mod == null) {
            return false;
        }
        if (mod.getClass() == modifyClass) {
            return true;
        }
        if (mod instanceof Modifications) {
            Modifications m = (Modifications)mod;
            for (Modification i : m.getModifications()) {
                if (i.getClass() != modifyClass) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean contains(CircuitComponent cc, ElementTypeDescription ... descriptions) {
        ArrayList<VisualElement> el = new ArrayList<VisualElement>(cc.getCircuit().getElements());
        if (el.size() < descriptions.length) {
            return false;
        }
        block0: for (ElementTypeDescription d : descriptions) {
            Iterator<VisualElement> it = el.iterator();
            while (it.hasNext()) {
                if (!it.next().equalsDescription(d)) continue;
                it.remove();
                continue block0;
            }
        }
        return el.isEmpty();
    }

    public InitialTutorial(Main main) {
        super(main, Lang.get("tutorial", new Object[0]), false);
        this.main = main;
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.circuitComponent = main.getCircuitComponent();
        this.circuitComponent.setTutorialListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                InitialTutorial.this.circuitComponent.setTutorialListener(null);
            }
        });
        this.text = new JTextPane();
        this.text.setEditable(false);
        this.text.setFont(Screen.getInstance().getFont(1.2f));
        this.text.setPreferredSize(new Dimension(300, 400));
        this.getContentPane().add(new JScrollPane(this.text));
        this.getContentPane().add((Component)new JButton(new AbstractAction(Lang.get("tutorialNotNeeded", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InitialTutorial.this.disableTutorial();
            }
        }), "South");
        this.pack();
        Point ml = main.getLocation();
        this.setLocation(Math.max(0, ml.x - this.getWidth()), ml.y);
        this.stepIndex = -1;
        this.incIndex();
    }

    private void disableTutorial() {
        Settings.getInstance().getAttributes().set(Keys.SETTINGS_SHOW_TUTORIAL, false);
        this.dispose();
    }

    private void incIndex() {
        do {
            ++this.stepIndex;
        } while (this.stepIndex < STEPS.size() && STEPS.get(this.stepIndex).getChecker().accomplished(this.circuitComponent, null, this));
        if (this.stepIndex == STEPS.size()) {
            this.disableTutorial();
        } else {
            this.setTextByID(STEPS.get(this.stepIndex).getId());
        }
    }

    private void setTextByID(String id) {
        String s = Lang.get(id, new Object[0]);
        this.text.setText(new LineBreaker(1000).breakLines(s));
    }

    @Override
    public void modified(Modification<Circuit> modification) {
        if (STEPS.get(this.stepIndex).getChecker().accomplished(this.circuitComponent, modification, this)) {
            this.incIndex();
        }
    }

    @Override
    public ModelEventType[] getEvents() {
        return new ModelEventType[]{ModelEventType.STEP};
    }

    @Override
    public void handleEvent(ModelEvent event) {
        if (event == ModelEvent.STEP) {
            this.modified(null);
        }
    }

    static {
        STEPS.add(new Step("tutorial1", (cc, mod, t) -> InitialTutorial.contains(cc, In.DESCRIPTION)));
        STEPS.add(new Step("tutorial2", (cc, mod, t) -> InitialTutorial.contains(cc, In.DESCRIPTION, In.DESCRIPTION)));
        STEPS.add(new Step("tutorial3", (cc, mod, t) -> InitialTutorial.contains(cc, In.DESCRIPTION, In.DESCRIPTION, XOr.DESCRIPTION)));
        STEPS.add(new Step("tutorial4", (cc, mod, t) -> InitialTutorial.contains(cc, In.DESCRIPTION, In.DESCRIPTION, XOr.DESCRIPTION, Out.DESCRIPTION)));
        STEPS.add(new Step("tutorial5", (cc, mod, t) -> InitialTutorial.contains(mod, ModifyInsertWire.class) || InitialTutorial.isWorking(cc)));
        STEPS.add(new Step("tutorial6", (cc, mod, t) -> InitialTutorial.isWorking(cc)));
        STEPS.add(new Step("tutorial7", (cc, mod, t) -> {
            Model model = t.main.getModel();
            if (model != null) {
                model.addObserver(t);
                return true;
            }
            return false;
        }));
        STEPS.add(new Step("tutorial8", (cc, mod, t) -> InitialTutorial.outputIsHigh(t)));
        STEPS.add(new Step("tutorial9", (cc, mod, t) -> t.main.getModel() == null));
        STEPS.add(new Step("tutorial10", (cc, mod, t) -> InitialTutorial.isIONamed(cc, 1, t)));
        STEPS.add(new Step("tutorial11", (cc, mod, t) -> InitialTutorial.isIONamed(cc, 3, t)));
    }

    private static interface Checker {
        public boolean accomplished(CircuitComponent var1, Modification<Circuit> var2, InitialTutorial var3);
    }

    private static final class Step {
        private final String id;
        private final Checker checker;

        private Step(String id, Checker checker) {
            this.id = id;
            this.checker = checker;
        }

        public String getId() {
            return this.id;
        }

        public Checker getChecker() {
            return this.checker;
        }
    }
}

