/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.remote;

import de.neemann.digital.gui.remote.HandlerInterface;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class RemoteSever
implements Runnable {
    private final HandlerInterface handler;
    private ServerSocket socket;
    private Thread thread;

    public RemoteSever(HandlerInterface handler) {
        this.handler = handler;
    }

    public void start(int port) throws IOException {
        this.socket = new ServerSocket(port);
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.thread.isInterrupted()) {
                Socket s = this.socket.accept();
                try {
                    DataInputStream in = new DataInputStream(s.getInputStream());
                    String request = in.readUTF();
                    String response = this.handler.handleRequest(request);
                    DataOutputStream out = new DataOutputStream(s.getOutputStream());
                    out.writeUTF(response);
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

