/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.remote;

import de.neemann.digital.gui.DigitalRemoteInterface;
import de.neemann.digital.gui.remote.HandlerInterface;
import de.neemann.digital.gui.remote.RemoteException;
import de.neemann.digital.lang.Lang;
import java.io.File;

public class DigitalHandler
implements HandlerInterface {
    private final DigitalRemoteInterface digitalRemoteInterface;

    public DigitalHandler(DigitalRemoteInterface digitalRemoteInterface) {
        this.digitalRemoteInterface = digitalRemoteInterface;
    }

    @Override
    public String handleRequest(String request) {
        int p = request.indexOf(58);
        String command = request;
        String args = null;
        if (p >= 0) {
            command = request.substring(0, p);
            args = request.substring(p + 1);
        }
        try {
            String ret = this.handle(command.toLowerCase(), args);
            if (ret != null) {
                return "ok:" + ret;
            }
            return "ok";
        }
        catch (RemoteException e) {
            return e.getMessage();
        }
    }

    private String handle(String command, String args) throws RemoteException {
        switch (command) {
            case "step": {
                return this.digitalRemoteInterface.doSingleStep();
            }
            case "clock": {
                return this.digitalRemoteInterface.doClock();
            }
            case "start": {
                this.digitalRemoteInterface.start(new File(args), false);
                return null;
            }
            case "debug": {
                this.digitalRemoteInterface.debug(new File(args), false);
                return null;
            }
            case "run": {
                return this.digitalRemoteInterface.runToBreak();
            }
            case "stop": {
                this.digitalRemoteInterface.stop();
                return null;
            }
            case "measure": {
                return this.digitalRemoteInterface.measure();
            }
        }
        throw new RemoteException(Lang.get("msg_remoteUnknownCommand", command));
    }
}

