/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.release;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.prefs.Preferences;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class ReleaseInfo {
    private static final String RELEASE_URL = "https://api.github.com/repos/hneemann/Digital/releases/latest";
    private static final String RELEASE_URL_NEW = "https://api.github.com/repos/hneemann/DigitaSi/releases/latest";
    private String version;
    private String url;

    ReleaseInfo() throws IOException {
        try {
            this.readReleaseInfo(RELEASE_URL_NEW);
            Preferences.userRoot().node("dig").put("newname", "DigitaSi");
        }
        catch (IOException e) {
            this.readReleaseInfo(RELEASE_URL);
        }
    }

    private void readReleaseInfo(String releaseUrl) throws IOException {
        try (InputStream in = new URL(releaseUrl).openStream();){
            JSONTokener tok = new JSONTokener(in);
            JSONObject obj = new JSONObject(tok);
            this.version = obj.get("tag_name").toString();
            this.url = obj.get("html_url").toString();
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }
}

