/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.testing;

import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.EditorFactory;
import de.neemann.digital.gui.components.TextLineNumber;
import de.neemann.digital.gui.components.modification.ModifyAttribute;
import de.neemann.digital.gui.components.table.ShowStringDialog;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.digital.testing.Transitions;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TestCaseDescriptionDialog
extends JDialog {
    private final JTextArea text;
    private final TestCaseDescription initialData;
    private final VisualElement element;
    private TestCaseDescription modifiedData;
    private boolean circuitModified = false;

    public TestCaseDescriptionDialog(Window parent, TestCaseDescription initialData) {
        this(parent, initialData, null);
    }

    public TestCaseDescriptionDialog(final Window parent, TestCaseDescription initialData, final VisualElement element) {
        super(parent, Lang.get("key_Testdata", new Object[0]), element == null ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.element = element;
        this.initialData = initialData;
        this.setDefaultCloseOperation(0);
        this.text = EditorFactory.addF1Traversal(new JTextArea(initialData.getDataString(), 30, 50));
        this.text.setFont(new Font("Monospaced", 0, Screen.getInstance().getFontSize()));
        EditorFactory.createUndoManager(this.text);
        this.addWindowListener(new ClosingWindowListener());
        JScrollPane scrollPane = new JScrollPane(this.text);
        this.getContentPane().add(scrollPane);
        scrollPane.setRowHeaderView(new TextLineNumber(this.text, 3));
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(new ToolTipAction(Lang.get("btn_help", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ShowStringDialog((Window)TestCaseDescriptionDialog.this, Lang.get("msg_testVectorHelpTitle", new Object[0]), Lang.get("msg_testVectorHelp", new Object[0]), true).setVisible(true);
            }
        }.createJButton());
        if (Main.isExperimentalMode()) {
            buttons.add(new ToolTipAction(Lang.get("btn_addTransitions", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (parent instanceof Main) {
                        CircuitComponent cc = ((Main)parent).getCircuitComponent();
                        try {
                            Transitions tr = new Transitions(TestCaseDescriptionDialog.this.text.getText(), cc.getCircuit().getInputNames());
                            if (tr.isNew()) {
                                TestCaseDescriptionDialog.this.text.setText(tr.getCompletedText());
                            }
                        }
                        catch (PinException | ParserException | IOException e1) {
                            new ErrorMessage(e1.getMessage()).show(TestCaseDescriptionDialog.this);
                        }
                    }
                }
            }.setToolTip(Lang.get("btn_addTransitions_tt", new Object[0])).createJButton());
        }
        buttons.add(new ToolTipAction(Lang.get("cancel", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestCaseDescriptionDialog.this.tryDispose();
            }
        }.createJButton());
        if (element != null) {
            buttons.add(new ToolTipAction(Lang.get("menu_runTests", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (parent instanceof Main) {
                            CircuitComponent cc = ((Main)parent).getCircuitComponent();
                            element.getElementAttributes().set(Keys.TESTDATA, new TestCaseDescription(TestCaseDescriptionDialog.this.text.getText()));
                            TestCaseDescriptionDialog.this.circuitModified = true;
                            cc.getMain().startTests();
                        }
                    }
                    catch (ParserException | IOException e1) {
                        new ErrorMessage(e1.getMessage()).show(TestCaseDescriptionDialog.this);
                    }
                }
            }.createJButton());
        }
        buttons.add(new ToolTipAction(Lang.get("ok", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TestCaseDescriptionDialog.this.modifiedData = new TestCaseDescription(TestCaseDescriptionDialog.this.text.getText());
                    if (element != null && TestCaseDescriptionDialog.this.isStateChanged() && parent instanceof Main) {
                        CircuitComponent cc = ((Main)parent).getCircuitComponent();
                        cc.modify(new ModifyAttribute<TestCaseDescription>(element, Keys.TESTDATA, TestCaseDescriptionDialog.this.modifiedData));
                    }
                    TestCaseDescriptionDialog.this.dispose();
                }
                catch (ParserException | IOException e1) {
                    new ErrorMessage(e1.getMessage()).show(TestCaseDescriptionDialog.this);
                }
            }
        }.createJButton());
        this.getContentPane().add((Component)buttons, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public TestCaseDescription showDialog() {
        this.modifiedData = null;
        this.setVisible(true);
        return this.modifiedData;
    }

    private boolean isStateChanged() {
        return !this.initialData.getDataString().equals(this.text.getText());
    }

    private void tryDispose() {
        if (this.isStateChanged()) {
            int r = JOptionPane.showOptionDialog(this, Lang.get("msg_dataWillBeLost_n", Keys.TESTDATA.getName()), Lang.get("msg_warning", new Object[0]), 0, 2, null, new String[]{Lang.get("btn_discard", new Object[0]), Lang.get("btn_editFurther", new Object[0])}, Lang.get("cancel", new Object[0]));
            if (r == 0) {
                this.myDispose();
            }
        } else {
            this.myDispose();
        }
    }

    private void myDispose() {
        this.dispose();
        if (this.circuitModified) {
            this.element.getElementAttributes().set(Keys.TESTDATA, this.initialData);
        }
    }

    private final class ClosingWindowListener
    extends WindowAdapter {
        private ClosingWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TestCaseDescriptionDialog.this.tryDispose();
        }
    }
}

