/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.terminal;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.terminal.CharDeleter;
import de.neemann.digital.gui.components.terminal.TerminalInterface;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public final class TerminalDialog
extends JDialog {
    private final JTextArea textArea;
    private final int width;
    private int pos;

    static TerminalInterface getTerminal(Model model, ElementAttributes attr) {
        return new MyTerminal(model, attr);
    }

    private static String getDialogTitle(ElementAttributes attr) {
        String t = attr.getLabel();
        if (t.length() > 0) {
            return t;
        }
        return Lang.get("elem_Terminal", new Object[0]);
    }

    private TerminalDialog(JFrame parent, ElementAttributes attr) {
        super(parent, TerminalDialog.getDialogTitle(attr), false);
        this.setDefaultCloseOperation(2);
        this.width = attr.get(Keys.TERM_WIDTH);
        this.textArea = new JTextArea(attr.get(Keys.TERM_HEIGHT), this.width);
        this.textArea.setFont(new Font("monospaced", 0, Screen.getInstance().getFontSize()));
        this.textArea.setEditable(false);
        this.getContentPane().add(new JScrollPane(this.textArea));
        JToolBar toolBar = new JToolBar();
        toolBar.add(new ToolTipAction(Lang.get("menu_terminalDelete", new Object[0]), CircuitComponent.ICON_DELETE){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalDialog.this.textArea.setText("");
            }
        }.setToolTip(Lang.get("menu_terminalDelete_tt", new Object[0])).createJButtonNoText());
        ToolTipAction copyAction = new ToolTipAction(Lang.get("menu_copy", new Object[0]), CircuitComponent.ICON_COPY){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(TerminalDialog.this.textArea.getText()), null);
            }
        }.setToolTip(Lang.get("menu_copy_tt", new Object[0])).setAcceleratorCTRLplus('C');
        toolBar.add(copyAction.createJButtonNoText());
        copyAction.enableAcceleratorIn(this.textArea);
        this.getContentPane().add((Component)toolBar, "North");
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void addChar(char value) {
        switch (value) {
            case '\n': 
            case '\r': {
                this.pos = 0;
                this.textArea.append("\n");
                break;
            }
            case '\b': {
                CharDeleter cd = new CharDeleter(this.textArea.getText(), this.pos).delete();
                this.textArea.setText(cd.getText());
                this.pos = cd.getPos();
                break;
            }
            case '\f': {
                this.pos = 0;
                this.textArea.setText("");
                break;
            }
            default: {
                this.textArea.append("" + value);
                ++this.pos;
                if (this.pos != this.width) break;
                this.pos = 0;
                this.textArea.append("\n");
            }
        }
    }

    private static final class MyTerminal
    implements TerminalInterface {
        private final Model model;
        private final ElementAttributes attr;
        private final StringBuilder text;
        private TerminalDialog terminalDialog;

        private MyTerminal(Model model, ElementAttributes attr) {
            this.model = model;
            this.attr = attr;
            this.text = new StringBuilder();
        }

        @Override
        public void addChar(char value) {
            SwingUtilities.invokeLater(() -> SwingUtilities.invokeLater(() -> {
                if (this.terminalDialog == null || !this.terminalDialog.isVisible()) {
                    this.terminalDialog = new TerminalDialog(this.model.getWindowPosManager().getMainFrame(), this.attr);
                    this.model.getWindowPosManager().register("terminal_" + this.attr.getLabel(), this.terminalDialog);
                }
                this.terminalDialog.addChar(value);
            }));
            if (this.text.length() < 2048) {
                this.text.append(value);
            }
        }

        @Override
        public String getText() {
            return this.text.toString();
        }
    }
}

