/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.terminal;

import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.gui.components.terminal.Keyboard;
import de.neemann.digital.lang.Lang;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class KeyboardDialog
extends JDialog
implements Keyboard.KeyboardInterface {
    private final JLabel textLabel;
    private final Object textLock = new Object();
    private String text;

    public KeyboardDialog(Frame owner, final Keyboard keyboard, final SyncAccess modelSync) {
        super(owner, Lang.get("elem_Keyboard", new Object[0]) + " " + keyboard.getLabel(), false);
        this.setDefaultCloseOperation(2);
        this.textLabel = new JLabel(Lang.get("msg_enterText", new Object[0]) + "          ");
        this.textLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(this.textLabel);
        this.text = "";
        this.textLabel.setFocusable(true);
        this.textLabel.setFocusTraversalKeysEnabled(false);
        this.textLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                this.appendChar(e.getKeyChar());
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: {
                        this.appendChar('\u0011');
                        break;
                    }
                    case 40: {
                        this.appendChar('\u0012');
                        break;
                    }
                    case 37: {
                        this.appendChar('\u0013');
                        break;
                    }
                    case 39: {
                        this.appendChar('\u0014');
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void appendChar(char c) {
                String t;
                Object object = KeyboardDialog.this.textLock;
                synchronized (object) {
                    KeyboardDialog.this.text = KeyboardDialog.this.text + String.valueOf(c);
                    t = KeyboardDialog.this.text;
                }
                modelSync.modify(keyboard::hasChanged);
                KeyboardDialog.this.textLabel.setText(t);
            }
        });
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
        keyboard.setKeyboard(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChar() {
        Object object = this.textLock;
        synchronized (object) {
            if (this.text.length() == 0) {
                return 0;
            }
            return this.text.charAt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFirstChar() {
        Object object = this.textLock;
        synchronized (object) {
            if (this.text.length() > 0) {
                String t = this.text = this.text.substring(1);
                SwingUtilities.invokeLater(() -> this.textLabel.setText(t));
            }
        }
    }
}

