/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.NamedExpression;
import de.neemann.digital.analyse.format.TruthTableFormatterLaTeX;
import de.neemann.digital.draw.graphics.text.formatter.LaTeXFormatter;
import de.neemann.digital.gui.components.table.ExpressionListener;

final class LaTeXExpressionListener
implements ExpressionListener {
    private final StringBuilder sb = new StringBuilder();

    LaTeXExpressionListener(TruthTable truthTable) throws ExpressionException {
        if (truthTable.getRows() <= 256) {
            String text = new TruthTableFormatterLaTeX().format(truthTable);
            this.sb.append(text);
        }
        this.sb.append("\\begin{eqnarray*}\n");
    }

    @Override
    public void resultFound(String name, Expression expression) {
        this.sb.append(LaTeXFormatter.format(new NamedExpression(name, expression))).append("\\\\\n");
    }

    @Override
    public void close() {
        this.sb.append("\\end{eqnarray*}\n");
    }

    public String toString() {
        return this.sb.toString();
    }
}

