/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.AnalyseException;
import de.neemann.digital.analyse.MinimizerInterface;
import de.neemann.digital.analyse.MinimizerQuineMcCluskey;
import de.neemann.digital.analyse.MinimizerQuineMcCluskeyExam;
import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.TableReducer;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.components.table.CheckResultListener;
import de.neemann.digital.gui.components.table.ExpressionListener;
import de.neemann.digital.gui.components.table.ExpressionListenerStore;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionCreator.class);
    private static final int MAX_INPUTS_ALLOWED = 12;
    private static final int COMPLEX_VAR_SIZE = 8;
    private final TruthTable theTable;
    private ProgressListener progressListener;

    public ExpressionCreator(TruthTable theTable) {
        this.theTable = theTable;
    }

    public void create(ExpressionListener listener) throws ExpressionException, FormatterException, AnalyseException {
        List<Variable> vars = Collections.unmodifiableList(this.theTable.getVars());
        long time = System.currentTimeMillis();
        if (this.theTable.getResultCount() >= 4 && vars.size() > 8) {
            LOGGER.debug("use parallel solvers");
            ExecutorService ex = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (int table = 0; table < this.theTable.getResultCount(); ++table) {
                ExpressionListenerStore l = new ExpressionListenerStore(null);
                jobs.add(this.simplify(l, vars, this.theTable.getResultName(table), this.theTable.getResult(table)).setStorage(l));
            }
            LOGGER.debug("jobs: " + jobs.size());
            ArrayList<Job> orderedJobs = new ArrayList<Job>(jobs);
            orderedJobs.sort(Comparator.comparingInt(job -> -((Job)job).getComplexity()));
            for (Job j : orderedJobs) {
                ex.submit(() -> {
                    try {
                        j.run();
                        j.close();
                    }
                    catch (ExpressionException | FormatterException e) {
                        e.printStackTrace();
                    }
                });
            }
            ex.shutdown();
            try {
                ex.awaitTermination(100L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (Job j : jobs) {
                j.getStorage().replayTo(listener);
            }
        } else {
            for (int table = 0; table < this.theTable.getResultCount(); ++table) {
                this.simplify(listener, vars, this.theTable.getResultName(table), this.theTable.getResult(table)).run();
            }
        }
        listener.close();
        time = System.currentTimeMillis() - time;
        LOGGER.debug("time: " + (double)time / 1000.0 + " sec");
        if (this.progressListener != null) {
            this.progressListener.complete();
        }
    }

    private Job simplify(ExpressionListener listener, List<Variable> vars, String resultName, BoolTable boolTable) throws AnalyseException, ExpressionException {
        TableReducer tr;
        List<Variable> localVars = vars;
        if (vars.size() > 4 && (tr = new TableReducer(vars, boolTable)).canReduce()) {
            LOGGER.debug(resultName + " reduced from " + vars.size() + " to " + tr.getVars().size() + " variables (" + tr.getVars() + ")");
            boolTable = tr.getTable();
            localVars = tr.getVars();
        }
        if (!Main.isExperimentalMode() && localVars.size() > 12) {
            throw new AnalyseException(Lang.get("err_toManyInputsIn_N0_max_N1_is_N2", resultName, 12, localVars.size()));
        }
        listener = new CheckResultListener(listener, localVars, boolTable);
        return new Job(localVars, boolTable, resultName, listener);
    }

    private MinimizerInterface getMinimizer(int size) {
        if (size <= 4) {
            return new MinimizerQuineMcCluskeyExam();
        }
        return new MinimizerQuineMcCluskey();
    }

    public ExpressionCreator setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    private final class Job {
        private final List<Variable> localVars;
        private final BoolTable boolTable;
        private final String resultName;
        private final ExpressionListener listener;
        private ExpressionListenerStore storage;

        private Job(List<Variable> localVars, BoolTable boolTable, String resultName, ExpressionListener listener) {
            this.localVars = localVars;
            this.boolTable = boolTable;
            this.resultName = resultName;
            this.listener = listener;
        }

        private void run() throws ExpressionException, FormatterException {
            LOGGER.debug("start job with complexity " + this.getComplexity());
            long time = System.currentTimeMillis();
            ExpressionCreator.this.getMinimizer(this.localVars.size()).minimize(this.localVars, this.boolTable, this.resultName, this.listener);
            LOGGER.debug("finished job with complexity " + this.getComplexity() + ":  " + (System.currentTimeMillis() - time) / 1000L + "sec");
            if (ExpressionCreator.this.progressListener != null) {
                ExpressionCreator.this.progressListener.oneCompleted();
            }
        }

        private int getComplexity() {
            return this.boolTable.realSize();
        }

        private void close() throws FormatterException, ExpressionException {
            this.listener.close();
        }

        private ExpressionListenerStore getStorage() {
            return this.storage;
        }

        private Job setStorage(ExpressionListenerStore storage) {
            this.storage = storage;
            return this;
        }
    }

    public static interface ProgressListener {
        public void oneCompleted();

        public void complete();
    }
}

