/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.gui.components.table.ExpressionComponent;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JScrollPane;

public class AllSolutionsDialog
extends JDialog {
    private final ExpressionComponent expressionComponent;
    private boolean userHasClosed = false;
    private boolean needed;
    private ToolTipAction reopenAction;

    AllSolutionsDialog(JDialog owner, Font font) {
        super(owner, Lang.get("win_allSolutions", new Object[0]), false);
        this.setDefaultCloseOperation(1);
        this.expressionComponent = new ExpressionComponent();
        this.expressionComponent.setPreferredSize(Screen.getInstance().scale(new Dimension(600, 300)));
        this.expressionComponent.setFont(font);
        this.expressionComponent.setBackground(Color.WHITE);
        JScrollPane scrollPane = new JScrollPane(this.expressionComponent);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.getContentPane().add(scrollPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AllSolutionsDialog.this.userHasClosed = true;
                if (AllSolutionsDialog.this.reopenAction != null) {
                    AllSolutionsDialog.this.reopenAction.setEnabled(true);
                }
            }
        });
        this.pack();
        this.setLocation(0, 0);
    }

    public void setNeeded(boolean needed, Rectangle tableDialogBounds) {
        this.needed = needed;
        if (!this.userHasClosed) {
            this.setVisible(needed);
            int x = (int)((double)tableDialogBounds.x - ((double)this.getWidth() - tableDialogBounds.getWidth()) / 2.0);
            int y = tableDialogBounds.y + tableDialogBounds.height + 10;
            if (this.getHeight() < tableDialogBounds.y - 10) {
                y = tableDialogBounds.y - this.getHeight() - 10;
            }
            this.setLocation(x, y);
            if (needed && this.reopenAction != null) {
                this.reopenAction.setEnabled(false);
            }
        }
    }

    public void setExpressions(ArrayList<Expression> expressions) {
        this.expressionComponent.setExpressions(expressions);
    }

    ToolTipAction getReopenAction() {
        if (this.reopenAction == null) {
            this.reopenAction = new ToolTipAction(Lang.get("menu_table_showAllSolutions", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AllSolutionsDialog.this.userHasClosed = false;
                    AllSolutionsDialog.this.reopenAction.setEnabled(false);
                    if (AllSolutionsDialog.this.needed) {
                        AllSolutionsDialog.this.setVisible(true);
                    }
                }
            }.setToolTip(Lang.get("menu_table_showAllSolutions_tt", new Object[0])).setEnabledChain(false);
        }
        return this.reopenAction;
    }
}

