/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.karnaugh;

import de.neemann.digital.draw.graphics.text.formatter.GraphicsFormatter;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Objects;

final class VarRectList {
    private final ArrayList<VarRect> varRectList = new ArrayList();
    private int xOffs;
    private int yOffs;

    VarRectList() {
    }

    public void reset(int xOffs, int yOffs) {
        this.xOffs = xOffs;
        this.yOffs = yOffs;
        this.varRectList.clear();
    }

    public void add(int var, boolean invert, Rectangle r, GraphicsFormatter.Fragment fr) {
        this.varRectList.add(new VarRect(var, invert, r, fr));
    }

    VarRect findVarRect(MouseEvent e) {
        int x = e.getX() - this.xOffs;
        int y = e.getY() - this.yOffs;
        for (VarRect r : this.varRectList) {
            if (!r.rect.contains(x, y)) continue;
            return r;
        }
        return null;
    }

    static final class VarRect {
        private final boolean invert;
        private final Rectangle rect;
        private final int var;
        private final GraphicsFormatter.Fragment fragment;

        private VarRect(int var, boolean invert, Rectangle rect, GraphicsFormatter.Fragment fragment) {
            this.var = var;
            this.invert = invert;
            this.rect = rect;
            this.fragment = fragment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VarRect varRect = (VarRect)o;
            return this.invert == varRect.invert && this.var == varRect.var;
        }

        public int hashCode() {
            return Objects.hash(this.invert, this.var);
        }

        int getVar() {
            return this.var;
        }

        boolean getInvert() {
            return this.invert;
        }

        GraphicsFormatter.Fragment getFragment() {
            return this.fragment;
        }

        public String toString() {
            return "VarRect{invert=" + this.invert + ", var=" + this.var + '}';
        }
    }
}

