/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.karnaugh;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.NamedExpression;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.gui.components.karnaugh.KarnaughMapComponent;
import de.neemann.digital.gui.components.table.ExpressionComponent;
import de.neemann.digital.gui.components.table.ExpressionListenerStore;
import de.neemann.digital.lang.Lang;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;

public class KarnaughMapDialog
extends JDialog {
    private final KarnaughMapComponent kvComponent;
    private final JComboBox<ExpressionListenerStore.Result> combo;
    private final JDialog parent;
    private TruthTable table;
    private List<ExpressionListenerStore.Result> results;

    public KarnaughMapDialog(JDialog parent, KarnaughMapComponent.Modifier modifier) {
        super(parent, Lang.get("win_karnaughMap", new Object[0]), false);
        this.parent = parent;
        this.setDefaultCloseOperation(1);
        this.kvComponent = new KarnaughMapComponent(modifier);
        this.getContentPane().add(this.kvComponent);
        this.combo = new JComboBox();
        this.combo.setRenderer(new MyDefaultListCellRenderer());
        this.getContentPane().add(this.combo, "North");
        this.combo.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int i = KarnaughMapDialog.this.combo.getSelectedIndex();
                if (i >= 0) {
                    BoolTable boolTable = KarnaughMapDialog.this.getResultTable(((ExpressionListenerStore.Result)KarnaughMapDialog.this.results.get(i)).getName());
                    if (boolTable != null) {
                        KarnaughMapDialog.this.kvComponent.setResult(KarnaughMapDialog.this.table.getVars(), boolTable, ((ExpressionListenerStore.Result)KarnaughMapDialog.this.results.get(i)).getExpression());
                    } else {
                        KarnaughMapDialog.this.kvComponent.showNothing();
                    }
                }
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private BoolTable getResultTable(String name) {
        for (int i = 0; i < this.table.getResultCount(); ++i) {
            if (!this.table.getResultName(i).endsWith(name)) continue;
            return this.table.getResult(i);
        }
        return null;
    }

    public void setResult(TruthTable table, List<ExpressionListenerStore.Result> newResults) {
        this.table = table;
        int i = this.combo.getSelectedIndex();
        String name = null;
        if (i >= 0 && i < this.results.size()) {
            name = this.results.get(i).getName();
        }
        this.results = newResults;
        this.combo.setModel(new MyComboBoxModel(this.results));
        if (this.results.size() > 0) {
            i = 0;
            for (int j = 0; j < this.results.size(); ++j) {
                if (!this.results.get(j).getName().equals(name)) continue;
                i = j;
                break;
            }
            this.combo.setSelectedIndex(i);
        }
    }

    public List<ExpressionListenerStore.Result> getResults() {
        return this.results;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isVisible()) {
            this.setLocation(this.parent.getX() + this.parent.getWidth(), this.parent.getY());
        }
        super.setVisible(visible);
    }

    private final class MyDefaultListCellRenderer
    extends ExpressionComponent
    implements ListCellRenderer<ExpressionListenerStore.Result> {
        private MyDefaultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ExpressionListenerStore.Result> jList, ExpressionListenerStore.Result result, int index, boolean isSelected, boolean focus) {
            if (result != null) {
                this.setExpression(new NamedExpression(result.getName(), result.getExpression()));
            } else {
                this.setExpression(null);
            }
            this.updateComponentSize(KarnaughMapDialog.this.combo.getGraphics());
            if (isSelected) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static final class MyComboBoxModel
    implements ComboBoxModel<ExpressionListenerStore.Result> {
        private List<ExpressionListenerStore.Result> results;
        private ExpressionListenerStore.Result selected;

        private MyComboBoxModel(List<ExpressionListenerStore.Result> results) {
            this.results = results;
        }

        public void setSelected(ExpressionListenerStore.Result selected) {
            this.selected = selected;
        }

        @Override
        public void setSelectedItem(Object o) {
            this.selected = (ExpressionListenerStore.Result)o;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.results == null ? 0 : this.results.size();
        }

        @Override
        public ExpressionListenerStore.Result getElementAt(int i) {
            return this.results.get(i);
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

