/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.karnaugh;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.draw.graphics.text.formatter.GraphicsFormatter;
import de.neemann.digital.gui.components.karnaugh.KarnaughException;
import de.neemann.digital.gui.components.karnaugh.KarnaughMap;
import de.neemann.digital.gui.components.karnaugh.MapLayout;
import de.neemann.digital.gui.components.karnaugh.VarRectList;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.Screen;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;

public class KarnaughMapComponent
extends JComponent {
    private static final int STROKE_WIDTH = 4;
    private static final Color[] COVER_COLORS = new Color[]{new Color(255, 0, 0, 128), new Color(0, 255, 0, 128), new Color(128, 0, 0, 128), new Color(0, 0, 128, 128), new Color(0, 0, 255, 128), new Color(255, 0, 255, 128), new Color(200, 200, 0, 128), new Color(0, 255, 255, 128)};
    private KarnaughMap kv;
    private BoolTable boolTable;
    private Expression exp;
    private ArrayList<Variable> vars;
    private Graphics2D gr;
    private String message = Lang.get("msg_noKVMapAvailable", new Object[0]);
    private final MapLayout mapLayout = new MapLayout(0);
    private final VarRectList varRectList = new VarRectList();
    private int xOffs;
    private int yOffs;
    private int cellSize;
    private int xDrag;
    private int yDrag;
    private VarRectList.VarRect startVarRect = null;

    public KarnaughMapComponent(Modifier tableCellModifier) {
        this.setPreferredSize(Screen.getInstance().scale(new Dimension(400, 400)));
        if (tableCellModifier != null) {
            MyMouseAdapter ma = new MyMouseAdapter(tableCellModifier);
            this.addMouseListener(ma);
            this.addMouseMotionListener(ma);
        }
    }

    public void setResult(ArrayList<Variable> vars, BoolTable boolTable, Expression exp) {
        this.vars = vars;
        this.mapLayout.checkSize(vars.size());
        this.boolTable = boolTable;
        this.exp = exp;
        this.update();
    }

    private void update() {
        try {
            this.kv = new KarnaughMap(this.vars, this.exp, this.mapLayout);
        }
        catch (KarnaughException e) {
            this.kv = null;
            this.message = e.getMessage();
        }
        this.repaint();
    }

    public void showNothing() {
        this.kv = null;
        this.message = Lang.get("msg_noKVMapAvailable", new Object[0]);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.gr = (Graphics2D)graphics;
        this.gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.gr.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        int width = this.getWidth();
        int height = this.getHeight();
        this.gr.setColor(Color.WHITE);
        this.gr.fillRect(0, 0, width, height);
        this.gr.setColor(Color.BLACK);
        if (this.kv != null) {
            int i;
            AffineTransform trans = this.gr.getTransform();
            int kvWidth = this.kv.getColumns();
            int kvHeight = this.kv.getRows();
            this.cellSize = (int)Math.min((float)height / ((float)kvHeight + 2.5f), (float)width / ((float)kvWidth + 2.5f));
            Font origFont = this.gr.getFont();
            Font valuesFont = origFont.deriveFont((float)this.cellSize * 0.5f);
            this.gr.setFont(valuesFont);
            Font headerFont = valuesFont;
            int maxHeaderStrWidth = 0;
            for (i = 0; i < this.vars.size(); ++i) {
                int w;
                GraphicsFormatter.Fragment fr = this.getFragment(i, true);
                if (fr == null || (w = fr.getWidth()) <= maxHeaderStrWidth) continue;
                maxHeaderStrWidth = w;
            }
            if (maxHeaderStrWidth > this.cellSize) {
                headerFont = origFont.deriveFont((float)this.cellSize * 0.5f * (float)this.cellSize / (float)maxHeaderStrWidth);
            }
            this.xOffs = (width - (kvWidth + 2) * this.cellSize) / 2;
            this.yOffs = (height - (kvHeight + 2) * this.cellSize) / 2;
            this.gr.translate(this.xOffs, this.yOffs);
            this.gr.setColor(Color.GRAY);
            this.gr.setStroke(new BasicStroke(2.0f));
            for (i = 0; i <= kvWidth; ++i) {
                int dy1 = this.isNoHeaderLine(this.kv.getHeaderTop(), i - 1) ? this.cellSize : 0;
                int dy2 = this.isNoHeaderLine(this.kv.getHeaderBottom(), i - 1) ? this.cellSize : 0;
                this.gr.drawLine((i + 1) * this.cellSize, dy1, (i + 1) * this.cellSize, (kvHeight + 2) * this.cellSize - dy2);
            }
            for (i = 0; i <= kvHeight; ++i) {
                int dx1 = this.isNoHeaderLine(this.kv.getHeaderLeft(), i - 1) ? this.cellSize : 0;
                int dx2 = this.isNoHeaderLine(this.kv.getHeaderRight(), i - 1) ? this.cellSize : 0;
                this.gr.drawLine(dx1, (i + 1) * this.cellSize, (kvWidth + 2) * this.cellSize - dx2, (i + 1) * this.cellSize);
            }
            this.gr.setStroke(new BasicStroke(4.0f));
            for (KarnaughMap.Cell cell : this.kv.getCells()) {
                this.gr.setColor(Color.BLACK);
                this.gr.setFont(valuesFont);
                this.drawString(this.boolTable.get(cell.getBoolTableRow()).toString(), cell.getCol() + 1, cell.getRow() + 1);
                this.gr.setColor(Color.GRAY);
                this.gr.setFont(origFont);
                this.gr.drawString(Integer.toString(cell.getBoolTableRow()), (cell.getCol() + 1) * this.cellSize + 1, (cell.getRow() + 2) * this.cellSize - 1);
            }
            this.varRectList.reset(this.xOffs, this.yOffs);
            this.gr.setColor(Color.BLACK);
            this.gr.setFont(headerFont);
            this.drawVerticalHeader(this.kv.getHeaderLeft(), 0);
            this.drawVerticalHeader(this.kv.getHeaderRight(), kvWidth + 1);
            this.drawHorizontalHeader(this.kv.getHeaderTop(), 0);
            this.drawHorizontalHeader(this.kv.getHeaderBottom(), kvHeight + 1);
            int color = 0;
            for (KarnaughMap.Cover c : this.kv) {
                this.gr.setColor(COVER_COLORS[color++]);
                KarnaughMap.Pos p = c.getPos();
                int frame = (c.getInset() + 1) * 4;
                int edgesRadius = this.cellSize - frame * 2;
                if (c.isDisconnected()) {
                    Rectangle clip = this.gr.getClipBounds();
                    this.gr.setClip(this.cellSize, this.cellSize, kvWidth * this.cellSize, kvHeight * this.cellSize);
                    if (c.onlyEdges()) {
                        this.gr.drawRoundRect(frame, frame, 2 * this.cellSize - frame * 2, 2 * this.cellSize - frame * 2, edgesRadius, edgesRadius);
                        this.gr.drawRoundRect(4 * this.cellSize + frame, frame, 2 * this.cellSize - frame * 2, 2 * this.cellSize - frame * 2, edgesRadius, edgesRadius);
                        this.gr.drawRoundRect(frame, 4 * this.cellSize + frame, 2 * this.cellSize - frame * 2, 2 * this.cellSize - frame * 2, edgesRadius, edgesRadius);
                        this.gr.drawRoundRect(4 * this.cellSize + frame, 4 * this.cellSize + frame, 2 * this.cellSize - frame * 2, 2 * this.cellSize - frame * 2, edgesRadius, edgesRadius);
                    } else {
                        int xofs = 0;
                        int yOfs = 0;
                        if (c.isVerticalDivided()) {
                            xofs = this.cellSize * 3;
                        } else {
                            yOfs = this.cellSize * 3;
                        }
                        this.gr.drawRoundRect((p.getCol() + 1) * this.cellSize + frame + xofs, (p.getRow() + 1) * this.cellSize + frame + yOfs, p.getWidth() * this.cellSize - frame * 2, p.getHeight() * this.cellSize - frame * 2, edgesRadius, edgesRadius);
                        this.gr.drawRoundRect((p.getCol() + 1) * this.cellSize + frame - xofs, (p.getRow() + 1) * this.cellSize + frame - yOfs, p.getWidth() * this.cellSize - frame * 2, p.getHeight() * this.cellSize - frame * 2, edgesRadius, edgesRadius);
                    }
                    this.gr.setClip(clip.x, clip.y, clip.width, clip.height);
                    continue;
                }
                this.gr.drawRoundRect((p.getCol() + 1) * this.cellSize + frame, (p.getRow() + 1) * this.cellSize + frame, p.getWidth() * this.cellSize - frame * 2, p.getHeight() * this.cellSize - frame * 2, edgesRadius, edgesRadius);
            }
            this.gr.setTransform(trans);
        } else {
            this.gr.drawString(this.message, 10, 20);
        }
        if (this.startVarRect != null) {
            this.gr.setColor(Color.BLACK);
            this.startVarRect.getFragment().draw(this.gr, this.xDrag, this.yDrag);
        }
    }

    private boolean isNoHeaderLine(KarnaughMap.Header header, int i) {
        if (header == null) {
            return false;
        }
        if (i < 0 || i >= header.size() - 1) {
            return false;
        }
        return header.getInvert(i) == header.getInvert(i + 1);
    }

    private void drawHorizontalHeader(KarnaughMap.Header header, int pos) {
        if (header != null) {
            for (int i = 0; i < header.size(); ++i) {
                int dx = 0;
                if (this.isNoHeaderLine(header, i)) {
                    ++i;
                    dx = this.cellSize / 2;
                }
                int var = header.getVar();
                boolean invert = header.getInvert(i);
                this.drawFragment(var, invert, i + 1, pos, dx, 0);
            }
        }
    }

    private void drawVerticalHeader(KarnaughMap.Header header, int pos) {
        if (header == null) {
            return;
        }
        for (int i = 0; i < header.size(); ++i) {
            int dy = 0;
            if (this.isNoHeaderLine(header, i)) {
                ++i;
                dy = this.cellSize / 2;
            }
            int var = header.getVar();
            boolean invert = header.getInvert(i);
            this.drawFragment(var, invert, pos, i + 1, 0, dy);
        }
    }

    private void drawString(String s, int row, int col) {
        FontMetrics fontMetrics = this.gr.getFontMetrics();
        Rectangle2D bounds = fontMetrics.getStringBounds(s, this.gr);
        int xPos = (int)(((double)this.cellSize - bounds.getWidth()) / 2.0);
        int yPos = this.cellSize - (int)(((double)this.cellSize - bounds.getHeight()) / 2.0) - fontMetrics.getDescent();
        this.gr.drawString(s, row * this.cellSize + xPos, col * this.cellSize + yPos);
    }

    private void drawFragment(int var, boolean invert, int row, int col, int xOffs, int yOffs) {
        GraphicsFormatter.Fragment fr = this.getFragment(var, invert);
        if (fr == null) {
            return;
        }
        FontMetrics fontMetrics = this.gr.getFontMetrics();
        int xPos = (this.cellSize - fr.getWidth()) / 2;
        int yPos = this.cellSize - (this.cellSize - fr.getHeight()) / 2 - fontMetrics.getDescent();
        int xFr = row * this.cellSize + xPos - xOffs;
        int yFr = col * this.cellSize + yPos - yOffs;
        fr.draw(this.gr, xFr, yFr);
        Rectangle r = new Rectangle(xFr, yFr + fontMetrics.getDescent() - fr.getHeight(), fr.getWidth(), fr.getHeight());
        this.varRectList.add(var, invert, r, fr);
    }

    private GraphicsFormatter.Fragment getFragment(int var, boolean invert) {
        try {
            if (invert) {
                return GraphicsFormatter.createFragment(this.gr, new Not(this.vars.get(var)));
            }
            return GraphicsFormatter.createFragment(this.gr, this.vars.get(var));
        }
        catch (GraphicsFormatter.FormatterException e) {
            return null;
        }
    }

    private final class MyMouseAdapter
    extends MouseAdapter {
        private final Modifier tableCellModifier;

        private MyMouseAdapter(Modifier tableCellModifier) {
            this.tableCellModifier = tableCellModifier;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (KarnaughMapComponent.this.kv != null) {
                int x = (mouseEvent.getX() - KarnaughMapComponent.this.xOffs) / KarnaughMapComponent.this.cellSize - 1;
                int y = (mouseEvent.getY() - KarnaughMapComponent.this.yOffs) / KarnaughMapComponent.this.cellSize - 1;
                if (x >= 0 && x < KarnaughMapComponent.this.kv.getColumns() && y >= 0 && y < KarnaughMapComponent.this.kv.getRows()) {
                    int row = KarnaughMapComponent.this.kv.getCell(y, x).getBoolTableRow();
                    this.tableCellModifier.modify(KarnaughMapComponent.this.boolTable, row);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            KarnaughMapComponent.this.startVarRect = KarnaughMapComponent.this.varRectList.findVarRect(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (KarnaughMapComponent.this.startVarRect != null) {
                KarnaughMapComponent.this.xDrag = e.getX();
                KarnaughMapComponent.this.yDrag = e.getY();
                KarnaughMapComponent.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            VarRectList.VarRect endVarRect = KarnaughMapComponent.this.varRectList.findVarRect(e);
            if (KarnaughMapComponent.this.mapLayout.swapByDragAndDrop(KarnaughMapComponent.this.startVarRect, endVarRect)) {
                KarnaughMapComponent.this.update();
            } else {
                KarnaughMapComponent.this.repaint();
            }
            KarnaughMapComponent.this.startVarRect = null;
        }
    }

    public static interface Modifier {
        public void modify(BoolTable var1, int var2);
    }
}

