/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.karnaugh;

import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.gui.components.karnaugh.KarnaughException;
import de.neemann.digital.gui.components.karnaugh.MapLayout;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class KarnaughMap
implements Iterable<Cover> {
    private final ArrayList<Cell> cells;
    private final List<Variable> vars;
    private final ArrayList<Cover> covers;
    private final Header headerLeft;
    private final Header headerRight;
    private final Header headerBottom;
    private final Header headerTop;

    public KarnaughMap(List<Variable> vars, Expression expr) throws KarnaughException {
        this(vars, expr, new MapLayout(vars.size()));
    }

    public KarnaughMap(List<Variable> vars, Expression expr, MapLayout mapLayout) throws KarnaughException {
        this.vars = vars;
        this.cells = new ArrayList();
        this.covers = new ArrayList();
        switch (vars.size()) {
            case 2: {
                for (int row = 0; row < 2; ++row) {
                    for (int col = 0; col < 2; ++col) {
                        this.cells.add(new Cell(row, col));
                    }
                }
                boolean leftMode = mapLayout.getInvert(0);
                this.headerLeft = new Header(mapLayout.get(0), new boolean[]{!leftMode, leftMode}).toRows(2, this);
                boolean topMode = mapLayout.getInvert(1);
                this.headerTop = new Header(mapLayout.get(1), new boolean[]{!topMode, topMode}).toCols(2, this);
                this.headerRight = null;
                this.headerBottom = null;
                break;
            }
            case 3: {
                for (int row = 0; row < 2; ++row) {
                    for (int col = 0; col < 4; ++col) {
                        this.cells.add(new Cell(row, col));
                    }
                }
                boolean leftMode = mapLayout.getInvert(0);
                this.headerLeft = new Header(mapLayout.get(0), new boolean[]{!leftMode, leftMode}).toRows(4, this);
                boolean topMode = mapLayout.getInvert(1);
                this.headerTop = new Header(mapLayout.get(1), new boolean[]{!topMode, !topMode, topMode, topMode}).toCols(2, this);
                boolean bottomMode = mapLayout.getInvert(2);
                this.headerBottom = new Header(mapLayout.get(2), new boolean[]{!bottomMode, bottomMode, bottomMode, !bottomMode}).toCols(2, this);
                this.headerRight = null;
                break;
            }
            case 4: {
                for (int row = 0; row < 4; ++row) {
                    for (int col = 0; col < 4; ++col) {
                        this.cells.add(new Cell(row, col));
                    }
                }
                boolean leftMode = mapLayout.getInvert(0);
                this.headerLeft = new Header(mapLayout.get(0), new boolean[]{!leftMode, !leftMode, leftMode, leftMode}).toRows(4, this);
                boolean rightMode = mapLayout.getInvert(1);
                this.headerRight = new Header(mapLayout.get(1), new boolean[]{!rightMode, rightMode, rightMode, !rightMode}).toRows(4, this);
                boolean topMode = mapLayout.getInvert(2);
                this.headerTop = new Header(mapLayout.get(2), new boolean[]{!topMode, !topMode, topMode, topMode}).toCols(4, this);
                boolean bottomMode = mapLayout.getInvert(3);
                this.headerBottom = new Header(mapLayout.get(3), new boolean[]{!bottomMode, bottomMode, bottomMode, !bottomMode}).toCols(4, this);
                break;
            }
            default: {
                throw new KarnaughException(Lang.get("err_toManyVars", new Object[0]));
            }
        }
        for (Cell c : this.cells) {
            c.createBoolTableRow();
        }
        this.addExpression(expr);
    }

    public Cell getCell(int row, int col) {
        for (Cell cell : this.cells) {
            if (!cell.is(row, col)) continue;
            return cell;
        }
        throw new RuntimeException("cell not found");
    }

    public ArrayList<Cell> getCells() {
        return this.cells;
    }

    private void addExpression(Expression expr) throws KarnaughException {
        if (expr instanceof Not || expr instanceof Variable) {
            this.addCover(expr);
        } else if (expr instanceof Operation.And) {
            this.addCover(((Operation.And)expr).getExpressions());
        } else if (expr instanceof Operation.Or) {
            for (Expression and : ((Operation.Or)expr).getExpressions()) {
                if (and instanceof Operation.And) {
                    this.addCover(((Operation.And)and).getExpressions());
                    continue;
                }
                if (and instanceof Not || and instanceof Variable) {
                    this.addCover(and);
                    continue;
                }
                throw new KarnaughException(Lang.get("err_invalidExpression", new Object[0]));
            }
        } else if (!(expr instanceof Constant)) {
            throw new KarnaughException(Lang.get("err_invalidExpression", new Object[0]));
        }
    }

    private void addCover(Expression expr) throws KarnaughException {
        this.addCoverToCells(new Cover().add(this.getVarOf(expr)));
    }

    private void addCover(ArrayList<Expression> expressions) throws KarnaughException {
        Cover cover = new Cover();
        for (Expression expr : expressions) {
            cover.add(this.getVarOf(expr));
        }
        this.addCoverToCells(cover);
    }

    private void addCoverToCells(Cover cover) {
        this.covers.add(cover);
        HashSet insetsUsed = new HashSet();
        for (Cell cell : this.cells) {
            cell.addCoverToCell(cover, insetsUsed);
        }
        for (int i = 0; i < 8; ++i) {
            if (insetsUsed.contains(i)) continue;
            cover.inset = i;
            break;
        }
    }

    private VarState getVarOf(Expression expression) throws KarnaughException {
        Expression ex;
        String name = null;
        boolean invert = false;
        if (expression instanceof Variable) {
            name = ((Variable)expression).getIdentifier();
            invert = false;
        } else if (expression instanceof Not && (ex = ((Not)expression).getExpression()) instanceof Variable) {
            name = ((Variable)ex).getIdentifier();
            invert = true;
        }
        if (name == null) {
            throw new KarnaughException(Lang.get("err_invalidExpression", new Object[0]));
        }
        int var = this.vars.indexOf(new Variable(name));
        if (var < 0) {
            throw new KarnaughException(Lang.get("err_invalidExpression", new Object[0]));
        }
        return new VarState(var, invert);
    }

    @Override
    public Iterator<Cover> iterator() {
        return this.covers.iterator();
    }

    public int size() {
        return this.covers.size();
    }

    public int getRows() {
        return this.headerLeft.size();
    }

    public int getColumns() {
        return this.headerTop.size();
    }

    public Header getHeaderLeft() {
        return this.headerLeft;
    }

    public Header getHeaderRight() {
        return this.headerRight;
    }

    public Header getHeaderBottom() {
        return this.headerBottom;
    }

    public Header getHeaderTop() {
        return this.headerTop;
    }

    public static final class Header {
        private final int var;
        private final boolean[] invert;

        private Header(int var, boolean ... invert) {
            this.var = var;
            this.invert = invert;
        }

        public int getVar() {
            return this.var;
        }

        public int size() {
            return this.invert.length;
        }

        public boolean getInvert(int i) {
            return this.invert[i];
        }

        public Header toRows(int cols, KarnaughMap kmap) {
            for (int row = 0; row < this.invert.length; ++row) {
                for (int col = 0; col < cols; ++col) {
                    kmap.getCell(row, col).add(new VarState(this.var, this.invert[row]));
                }
            }
            return this;
        }

        public Header toCols(int rows, KarnaughMap kmap) {
            for (int col = 0; col < this.invert.length; ++col) {
                for (int row = 0; row < rows; ++row) {
                    kmap.getCell(row, col).add(new VarState(this.var, this.invert[col]));
                }
            }
            return this;
        }
    }

    public static final class Pos {
        private final int row;
        private final int col;
        private final int width;
        private final int height;

        private Pos(int row, int col, int width, int height) {
            this.row = row;
            this.col = col;
            this.width = width;
            this.height = height;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public final class Cover {
        private final ArrayList<VarState> varStates = new ArrayList();
        private Pos pos;
        private int cellCount;
        private int inset = 0;

        private Cover() {
        }

        private Cover add(VarState varState) {
            this.varStates.add(varState);
            return this;
        }

        private boolean contains(VarState s) {
            return this.varStates.contains(s);
        }

        public Pos getPos() {
            if (this.pos == null) {
                int rowMin = Integer.MAX_VALUE;
                int rowMax = Integer.MIN_VALUE;
                int colMin = Integer.MAX_VALUE;
                int colMax = Integer.MIN_VALUE;
                for (Cell c : KarnaughMap.this.cells) {
                    if (!c.contains(this)) continue;
                    if (c.row > rowMax) {
                        rowMax = c.row;
                    }
                    if (c.row < rowMin) {
                        rowMin = c.row;
                    }
                    if (c.col > colMax) {
                        colMax = c.col;
                    }
                    if (c.col >= colMin) continue;
                    colMin = c.col;
                }
                int width = colMax - colMin + 1;
                int height = rowMax - rowMin + 1;
                this.pos = new Pos(rowMin, colMin, width, height);
            }
            return this.pos;
        }

        private void incCellCount() {
            ++this.cellCount;
        }

        public int getSize() {
            return this.cellCount;
        }

        public int getInset() {
            return this.inset;
        }

        public boolean isDisconnected() {
            return this.getPos().width * this.getPos().height > this.cellCount;
        }

        public boolean onlyEdges() {
            return this.getPos().width * this.getPos().height == 16 && this.cellCount == 4;
        }

        public boolean isVerticalDivided() {
            Pos p = this.getPos();
            if (p.width * p.height == 16 && this.cellCount == 8) {
                return KarnaughMap.this.getCell(1, 0).contains(this);
            }
            return p.getWidth() > p.getHeight();
        }
    }

    private static final class VarState {
        private final int num;
        private final boolean invert;

        private VarState(int num, boolean invert) {
            this.num = num;
            this.invert = invert;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VarState varState = (VarState)o;
            if (this.num != varState.num) {
                return false;
            }
            return this.invert == varState.invert;
        }

        public int hashCode() {
            int result = this.num;
            result = 31 * result + (this.invert ? 1 : 0);
            return result;
        }

        private VarState not() {
            return new VarState(this.num, !this.invert);
        }
    }

    public static final class Cell {
        private final int row;
        private final int col;
        private final ArrayList<VarState> minTerm;
        private final ArrayList<Cover> covers;
        private int boolTableRow;

        private Cell(int row, int col) {
            this.row = row;
            this.col = col;
            this.minTerm = new ArrayList();
            this.covers = new ArrayList();
        }

        private void add(VarState varState) {
            this.minTerm.add(varState);
        }

        private boolean is(int row, int col) {
            return this.row == row && this.col == col;
        }

        private void addCoverToCell(Cover cover, HashSet<Integer> insetsUsed) {
            for (VarState s : this.minTerm) {
                if (!cover.contains(s.not())) continue;
                return;
            }
            for (Cover c : this.covers) {
                insetsUsed.add(c.inset);
            }
            this.covers.add(cover);
            cover.incCellCount();
        }

        private boolean contains(Cover cover) {
            return this.covers.contains(cover);
        }

        private void createBoolTableRow() {
            int tableCols = this.minTerm.size();
            this.boolTableRow = 0;
            for (VarState i : this.minTerm) {
                if (i.invert) continue;
                this.boolTableRow += 1 << tableCols - i.num - 1;
            }
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public int getBoolTableRow() {
            return this.boolTableRow;
        }

        boolean isVarInMinTerm(int var, boolean invert) {
            return this.minTerm.contains(new VarState(var, invert));
        }
    }
}

