/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.graphics;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.gui.components.graphics.VGADialog;
import de.neemann.digital.lang.Lang;
import java.awt.Color;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public class VGA
extends Node
implements Element {
    private static final HashMap<VideoId, VideoMode> MODES = new HashMap();
    public static final ElementTypeDescription DESCRIPTION;
    private ObservableValue r;
    private ObservableValue g;
    private ObservableValue b;
    private ObservableValue hSync;
    private ObservableValue vSync;
    private ObservableValue clock;
    private boolean lastClock;
    private int xPos;
    private int yPos;
    private int lineCount;
    private int lineLen;
    private int lineLenStable;
    private int lineCountStable;
    private long maxCol;
    private BufferedImage image;
    private VideoMode mode;
    private SyncDetector hSyncDetection = new SyncDetector();
    private SyncDetector vSyncDetection = new SyncDetector();
    private VGADialog graphicDialog;
    private String label;
    private final AtomicBoolean paintPending = new AtomicBoolean();

    private static void vm(VideoMode videoMode) {
        MODES.put(videoMode.id(), videoMode);
    }

    public VGA(ElementAttributes attr) {
        this.label = attr.getLabel();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.r = (ObservableValue)inputs.get(0);
        int bits = this.r.getBits();
        this.maxCol = Bits.up(1L, bits) - 1L;
        this.g = ((ObservableValue)inputs.get(1)).checkBits(bits, this);
        this.b = ((ObservableValue)inputs.get(2)).checkBits(bits, this);
        this.hSync = ((ObservableValue)inputs.get(3)).checkBits(1, this);
        this.vSync = ((ObservableValue)inputs.get(4)).checkBits(1, this);
        this.clock = ((ObservableValue)inputs.get(5)).checkBits(1, this).addObserverToValue(this);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean actClock = this.clock.getBool();
        if (actClock && !this.lastClock) {
            ++this.xPos;
            if (this.hSyncDetection.add(this.hSync.getBool())) {
                this.setLineLen(this.xPos);
                this.xPos = 0;
                ++this.yPos;
            }
            if (this.vSyncDetection.add(this.vSync.getBool())) {
                this.setLineCount(this.yPos);
                this.yPos = 0;
            }
            if (this.lineCountStable > 2 && this.lineLenStable > 100) {
                this.setPixel(this.xPos, this.yPos, new Color(this.col(this.r.getValue()), this.col(this.g.getValue()), this.col(this.b.getValue())));
            }
        }
        this.lastClock = actClock;
    }

    private void setPixel(int xPos, int yPos, Color color) {
        if (this.mode == null) {
            VideoId id = new VideoId(this.lineLen, this.hSyncDetection.syncPulse(), this.hSyncDetection.isNegPolarity(), this.lineCount, (this.vSyncDetection.syncPulse() + this.lineLen / 2) / this.lineLen, this.vSyncDetection.isNegPolarity());
            this.mode = MODES.get(id);
            if (this.mode == null) {
                throw new RuntimeException(Lang.get("err_vgaModeNotDetected_N", id));
            }
            this.image = this.mode.createImage();
        }
        this.mode.set(this.image, xPos, yPos, color);
        this.updateGraphic();
    }

    private int col(long value) {
        return (int)(value * 255L / this.maxCol);
    }

    private void setLineCount(int lc) {
        this.lineCountStable = lc == this.lineCount ? ++this.lineCountStable : 0;
        this.lineCount = lc;
    }

    private void setLineLen(int ll) {
        this.lineLenStable = ll == this.lineLen ? ++this.lineLenStable : 0;
        this.lineLen = ll;
    }

    @Override
    public void writeOutputs() throws NodeException {
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void init(Model model) {
    }

    private void updateGraphic() {
        if (this.paintPending.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(() -> {
                if (this.graphicDialog == null || !this.graphicDialog.isVisible()) {
                    this.graphicDialog = new VGADialog((Window)this.getModel().getWindowPosManager().getMainFrame(), this.mode.toString(), this.image);
                    this.getModel().getWindowPosManager().register("VGA_" + this.label, this.graphicDialog);
                }
                this.paintPending.set(false);
                this.graphicDialog.updateGraphic();
            });
        }
    }

    static {
        VGA.vm(new VideoMode(70, 25.175, 640, 16, 96, 48, 350, 37, 2, 60, false, true));
        VGA.vm(new VideoMode(85, 31.5, 640, 32, 64, 96, 350, 32, 3, 60, false, true));
        VGA.vm(new VideoMode(70, 25.175, 640, 16, 96, 48, 400, 12, 2, 35, true, false));
        VGA.vm(new VideoMode(85, 31.5, 640, 32, 64, 96, 400, 1, 3, 41, true, false));
        VGA.vm(new VideoMode(60, 25.175, 640, 16, 96, 48, 480, 10, 2, 33, true, true));
        VGA.vm(new VideoMode(60, 25.0, 640, 16, 96, 48, 480, 10, 8, 23, true, true));
        VGA.vm(new VideoMode(73, 31.5, 640, 24, 40, 128, 480, 9, 2, 29, true, true));
        VGA.vm(new VideoMode(75, 31.5, 640, 16, 64, 120, 480, 1, 3, 16, true, true));
        VGA.vm(new VideoMode(85, 36.0, 640, 56, 56, 80, 480, 1, 3, 25, true, true));
        VGA.vm(new VideoMode(100, 43.16, 640, 40, 64, 104, 480, 1, 3, 25, true, false));
        VGA.vm(new VideoMode(85, 35.5, 720, 36, 72, 108, 400, 1, 3, 42, true, false));
        VGA.vm(new VideoMode(60, 27.0, 720, 16, 62, 60, 480, 9, 6, 30, true, true));
        VGA.vm(new VideoMode(60, 34.96, 768, 24, 80, 104, 576, 1, 3, 17, true, false));
        VGA.vm(new VideoMode(72, 42.93, 768, 32, 80, 112, 576, 1, 3, 21, true, false));
        VGA.vm(new VideoMode(75, 45.51, 768, 40, 80, 120, 576, 1, 3, 22, true, false));
        VGA.vm(new VideoMode(85, 51.84, 768, 40, 80, 120, 576, 1, 3, 25, true, false));
        VGA.vm(new VideoMode(100, 62.57, 768, 48, 80, 128, 576, 1, 3, 31, true, false));
        VGA.vm(new VideoMode(56, 36.0, 800, 24, 72, 128, 600, 1, 2, 22, false, false));
        VGA.vm(new VideoMode(60, 40.0, 800, 40, 128, 88, 600, 1, 4, 23, false, false));
        VGA.vm(new VideoMode(75, 49.5, 800, 16, 80, 160, 600, 1, 3, 21, false, false));
        VGA.vm(new VideoMode(72, 50.0, 800, 56, 120, 64, 600, 37, 6, 23, false, false));
        VGA.vm(new VideoMode(85, 56.25, 800, 32, 64, 152, 600, 1, 3, 27, false, false));
        VGA.vm(new VideoMode(100, 68.18, 800, 48, 88, 136, 600, 1, 3, 32, true, false));
        VGA.vm(new VideoMode(43, 44.9, 1024, 8, 176, 56, 768, 0, 8, 41, false, false));
        VGA.vm(new VideoMode(60, 65.0, 1024, 24, 136, 160, 768, 3, 6, 29, true, true));
        VGA.vm(new VideoMode(70, 75.0, 1024, 24, 136, 144, 768, 3, 6, 29, true, true));
        VGA.vm(new VideoMode(75, 78.8, 1024, 16, 96, 176, 768, 1, 3, 28, false, false));
        VGA.vm(new VideoMode(85, 94.5, 1024, 48, 96, 208, 768, 1, 3, 36, false, false));
        VGA.vm(new VideoMode(100, 113.31, 1024, 72, 112, 184, 768, 1, 3, 42, true, false));
        VGA.vm(new VideoMode(75, 108.0, 1152, 64, 128, 256, 864, 1, 3, 32, false, false));
        VGA.vm(new VideoMode(85, 119.65, 1152, 72, 128, 200, 864, 1, 3, 39, true, false));
        VGA.vm(new VideoMode(100, 143.47, 1152, 80, 128, 208, 864, 1, 3, 47, true, false));
        VGA.vm(new VideoMode(60, 81.62, 1152, 64, 120, 184, 864, 1, 3, 27, true, false));
        VGA.vm(new VideoMode(60, 72.25, 1280, 110, 40, 220, 720, 5, 5, 20, false, false));
        VGA.vm(new VideoMode(60, 108.0, 1280, 48, 112, 248, 1024, 1, 3, 38, false, false));
        VGA.vm(new VideoMode(75, 135.0, 1280, 16, 144, 248, 1024, 1, 3, 38, false, false));
        VGA.vm(new VideoMode(85, 157.5, 1280, 64, 160, 224, 1024, 1, 3, 44, false, false));
        VGA.vm(new VideoMode(100, 190.96, 1280, 96, 144, 240, 1024, 1, 3, 57, true, false));
        VGA.vm(new VideoMode(60, 83.46, 1280, 64, 136, 200, 800, 1, 3, 24, true, false));
        VGA.vm(new VideoMode(60, 102.1, 1280, 80, 136, 216, 960, 1, 3, 30, true, false));
        VGA.vm(new VideoMode(72, 124.54, 1280, 88, 136, 224, 960, 1, 3, 37, true, false));
        VGA.vm(new VideoMode(75, 129.86, 1280, 88, 136, 224, 960, 1, 3, 38, true, false));
        VGA.vm(new VideoMode(85, 148.5, 1280, 64, 160, 224, 960, 1, 3, 47, false, false));
        VGA.vm(new VideoMode(100, 178.99, 1280, 96, 144, 240, 960, 1, 3, 53, true, false));
        VGA.vm(new VideoMode(60, 85.86, 1368, 72, 144, 216, 768, 1, 3, 23, true, false));
        VGA.vm(new VideoMode(60, 122.61, 1400, 88, 152, 240, 1050, 1, 3, 33, true, false));
        VGA.vm(new VideoMode(72, 149.34, 1400, 96, 152, 248, 1050, 1, 3, 40, true, false));
        VGA.vm(new VideoMode(75, 155.85, 1400, 96, 152, 248, 1050, 1, 3, 42, true, false));
        VGA.vm(new VideoMode(85, 179.26, 1400, 104, 152, 256, 1050, 1, 3, 49, true, false));
        VGA.vm(new VideoMode(100, 214.39, 1400, 112, 152, 264, 1050, 1, 3, 58, true, false));
        VGA.vm(new VideoMode(60, 106.47, 1440, 80, 152, 232, 900, 1, 3, 28, true, false));
        VGA.vm(new VideoMode(60, 162.0, 1600, 64, 192, 304, 1200, 1, 3, 46, false, false));
        VGA.vm(new VideoMode(100, 280.64, 1600, 128, 176, 304, 1200, 1, 3, 67, true, false));
        VGA.vm(new VideoMode(60, 147.14, 1680, 104, 184, 288, 1050, 1, 3, 33, true, false));
        VGA.vm(new VideoMode(60, 204.8, 1792, 128, 200, 328, 1344, 1, 3, 46, true, false));
        VGA.vm(new VideoMode(75, 261.0, 1792, 96, 216, 352, 1344, 1, 3, 69, true, false));
        VGA.vm(new VideoMode(60, 218.3, 1856, 96, 224, 352, 1392, 1, 3, 43, true, false));
        VGA.vm(new VideoMode(75, 288.0, 1856, 128, 224, 352, 1392, 1, 3, 104, true, false));
        VGA.vm(new VideoMode(60, 148.5, 1920, 88, 44, 148, 1080, 4, 4, 37, true, true));
        VGA.vm(new VideoMode(60, 193.16, 1920, 128, 208, 336, 1200, 1, 3, 38, true, false));
        VGA.vm(new VideoMode(60, 234.0, 1920, 128, 208, 344, 1440, 1, 3, 56, true, false));
        VGA.vm(new VideoMode(75, 297.0, 1920, 144, 224, 352, 1440, 1, 3, 56, true, false));
        DESCRIPTION = new ElementTypeDescription(VGA.class, PinInfo.input("R"), PinInfo.input("G"), PinInfo.input("B"), PinInfo.input("H"), PinInfo.input("V"), PinInfo.input("C").setClock()).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL);
    }

    private static final class VideoId {
        private final int width;
        private final int hSync;
        private final boolean hNegative;
        private final int height;
        private final int vSync;
        private final boolean vNegative;

        private VideoId(int width, int hSync, boolean hNegative, int height, int vSync, boolean vNegative) {
            this.width = width;
            this.hSync = hSync;
            this.hNegative = hNegative;
            this.height = height;
            this.vSync = vSync;
            this.vNegative = vNegative;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VideoId videoId = (VideoId)o;
            return this.width == videoId.width && this.hSync == videoId.hSync && this.hNegative == videoId.hNegative && this.height == videoId.height && this.vSync == videoId.vSync && this.vNegative == videoId.vNegative;
        }

        public int hashCode() {
            return Objects.hash(this.width, this.hSync, this.hNegative, this.height, this.vSync, this.vNegative);
        }

        public String toString() {
            return "line len=" + this.width + ", hSync len=" + this.hSync + ", hNegative=" + this.hNegative + ", line count=" + this.height + ", vSync len=" + this.vSync + ", vNegative=" + this.vNegative;
        }
    }

    private static final class VideoMode {
        private final int refresh;
        private final double pixClock;
        private final int hDisplay;
        private final int hFrontPorch;
        private final int hSync;
        private final int hBackPorch;
        private final int vDisplay;
        private final int vFrontPorch;
        private final int vSync;
        private final int vBackPorch;
        private final boolean hNegative;
        private final boolean vNegative;

        private VideoMode(int refresh, double pixClock, int hDisplay, int hFrontPorch, int hSync, int hBackPorch, int vDisplay, int vFrontPorch, int vSync, int vBackPorch, boolean hNegative, boolean vNegative) {
            this.refresh = refresh;
            this.pixClock = pixClock;
            this.hDisplay = hDisplay;
            this.hFrontPorch = hFrontPorch;
            this.hSync = hSync;
            this.hBackPorch = hBackPorch;
            this.vDisplay = vDisplay;
            this.vFrontPorch = vFrontPorch;
            this.vSync = vSync;
            this.vBackPorch = vBackPorch;
            this.hNegative = hNegative;
            this.vNegative = vNegative;
        }

        public String toString() {
            return this.hDisplay + "x" + this.vDisplay + "x" + this.refresh + "Hz, " + this.pixClock + "MHz";
        }

        public VideoId id() {
            return new VideoId(this.hDisplay + this.hFrontPorch + this.hSync + this.hBackPorch, this.hSync, this.hNegative, this.vDisplay + this.vFrontPorch + this.vSync + this.vBackPorch, this.vSync, this.vNegative);
        }

        private BufferedImage createImage() {
            return new BufferedImage(this.hDisplay, this.vDisplay, 1);
        }

        private void set(BufferedImage image, int xPos, int yPos, Color color) {
            if ((xPos -= this.hBackPorch) >= 0 && xPos < this.hDisplay && (yPos -= this.vBackPorch) >= 0 && yPos < this.vDisplay) {
                image.setRGB(xPos, yPos, color.getRGB());
            }
        }
    }

    static class SyncDetector {
        private boolean lastS;
        private int high;
        private int highLen;
        private int low;
        private int lowLen;

        SyncDetector() {
        }

        boolean add(boolean s) {
            if (s) {
                ++this.high;
                if (!this.lastS) {
                    this.lowLen = this.low;
                    this.low = 0;
                }
            } else {
                ++this.low;
                if (this.lastS) {
                    this.highLen = this.high;
                    this.high = 0;
                }
            }
            boolean result = false;
            if (this.lowLen > 0 && this.highLen > 0) {
                result = this.lowLen > this.highLen ? this.lastS & !s : !this.lastS & s;
            }
            this.lastS = s;
            return result;
        }

        boolean isNegPolarity() {
            return this.lowLen < this.highLen;
        }

        int syncPulse() {
            if (this.isNegPolarity()) {
                return this.lowLen;
            }
            return this.highLen;
        }
    }
}

