/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class LedMatrixComponent
extends JComponent {
    private final int width;
    private final int height;
    private final long[] data;
    private final Color color;
    private final boolean ledPersist;
    private int lastCol;

    public LedMatrixComponent(int dy, long[] data, Color color, boolean ledPersist) {
        int ph;
        this.width = data.length;
        this.height = dy;
        this.data = data;
        this.color = color;
        this.ledPersist = ledPersist;
        int pw = 320 / this.width;
        if (pw < 2) {
            pw = 2;
        }
        if ((ph = 200 / this.height) < 2) {
            ph = 2;
        }
        int ledSize = (pw + ph) / 2;
        Dimension size = new Dimension(this.width * ledSize, this.height * ledSize);
        this.setPreferredSize(size);
        this.setOpaque(false);
    }

    public void updateGraphic(int colAddr, long rowData) {
        this.lastCol = colAddr;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        for (int x = 0; x < this.width; ++x) {
            int xPos = x * this.getWidth() / this.width;
            int dx = (x + 1) * this.getWidth() / this.width - xPos;
            long word = this.data[x];
            long mask = 1L;
            for (int y = 0; y < this.height; ++y) {
                boolean ledState;
                boolean bl = ledState = (word & mask) != 0L;
                if (ledState && (this.ledPersist || x == this.lastCol)) {
                    g.setColor(this.color);
                } else {
                    g.setColor(Color.BLACK);
                }
                int ypos = y * this.getHeight() / this.height;
                int dy = (y + 1) * this.getHeight() / this.height - ypos;
                g.fillOval(xPos, ypos, dx, dy);
                mask *= 2L;
            }
        }
    }
}

