/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class GraphicComponent
extends JComponent {
    private static final Color[] PALETTE = GraphicComponent.createPalette();
    private final int width;
    private final int height;
    private long[] data;
    private int offs;

    public GraphicComponent(int width, int height) {
        int ph;
        this.width = width;
        this.height = height;
        int pw = 640 / width;
        if (pw < 1) {
            pw = 1;
        }
        if ((ph = 400 / height) < 1) {
            ph = 1;
        }
        int pixSize = (pw + ph) / 2;
        Dimension size = new Dimension(width * pixSize, height * pixSize);
        this.setPreferredSize(size);
        this.setOpaque(true);
    }

    public void updateGraphic(long[] data, boolean bank) {
        this.data = data;
        this.offs = bank ? this.width * this.height : 0;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.data != null) {
            for (int x = 0; x < this.width; ++x) {
                int xPos = x * this.getWidth() / this.width;
                int dx = (x + 1) * this.getWidth() / this.width - xPos;
                for (int y = 0; y < this.height; ++y) {
                    int p = (int)this.data[this.offs + y * this.width + x];
                    if (p >= PALETTE.length) {
                        p = 1;
                    }
                    g.setColor(PALETTE[p]);
                    int ypos = y * this.getHeight() / this.height;
                    int dy = (y + 1) * this.getHeight() / this.height - ypos;
                    g.fillRect(xPos, ypos, dx, dy);
                }
            }
        }
    }

    private static Color[] createPalette() {
        int b;
        int g;
        int r;
        Color[] col = new Color[65536];
        for (int i = 0; i < col.length; ++i) {
            col[i] = Color.BLACK;
        }
        col[0] = Color.WHITE;
        col[1] = Color.BLACK;
        col[2] = Color.RED;
        col[3] = Color.GREEN;
        col[4] = Color.BLUE;
        col[5] = Color.YELLOW;
        col[6] = Color.CYAN;
        col[7] = Color.MAGENTA;
        col[8] = Color.ORANGE;
        col[9] = Color.PINK;
        for (int g2 = 0; g2 < 32; ++g2) {
            int in = 255 - GraphicComponent.getComp(g2, 32);
            col[32 + g2] = new Color(in, in, in);
        }
        int index = 64;
        for (r = 0; r < 4; ++r) {
            for (g = 0; g < 4; ++g) {
                for (b = 0; b < 4; ++b) {
                    col[index] = new Color(GraphicComponent.getComp(r, 4), GraphicComponent.getComp(g, 4), GraphicComponent.getComp(b, 4));
                    ++index;
                }
            }
        }
        index = 32768;
        for (r = 0; r < 32; ++r) {
            for (g = 0; g < 32; ++g) {
                for (b = 0; b < 32; ++b) {
                    col[index] = new Color(GraphicComponent.getComp(r, 32), GraphicComponent.getComp(g, 32), GraphicComponent.getComp(b, 32));
                    ++index;
                }
            }
        }
        return col;
    }

    private static int getComp(int c, int values) {
        return 255 * c / (values - 1);
    }
}

