/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.data;

import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.Signal;
import de.neemann.digital.data.Value;
import de.neemann.digital.data.ValueTable;
import de.neemann.digital.testing.parser.TestRow;
import java.util.ArrayList;

public class ValueTableObserver
implements ModelStateObserverTyped {
    private final ValueTable logData;
    private final Condition condition;
    private final ModelEventType[] events;
    private final ArrayList<Signal> signals;

    public ValueTableObserver(boolean microStep, ArrayList<Signal> signals, int maxSize) {
        this.signals = signals;
        if (microStep) {
            this.condition = type -> type == ModelEventType.MICROSTEP;
            this.events = new ModelEventType[]{ModelEventType.MICROSTEP};
        } else {
            this.condition = type -> type == ModelEventType.STEP || type == ModelEventType.CHECKBURN;
            this.events = new ModelEventType[]{ModelEventType.STEP, ModelEventType.CHECKBURN};
        }
        String[] names = new String[signals.size()];
        for (int i = 0; i < signals.size(); ++i) {
            names[i] = signals.get(i).getName();
        }
        this.logData = new ValueTable(names).setMaxSize(maxSize);
    }

    @Override
    public void handleEvent(ModelEvent event) {
        if (event == ModelEvent.STARTED) {
            this.logData.clear();
        }
        if (this.condition.accept(event.getType())) {
            Value[] row = new Value[this.logData.getColumns()];
            for (int i = 0; i < this.logData.getColumns(); ++i) {
                row[i] = new Value(this.signals.get(i).getValue());
            }
            this.logData.add(new TestRow(row));
        }
    }

    @Override
    public ModelEventType[] getEvents() {
        return this.events;
    }

    public ValueTable getLogData() {
        return this.logData;
    }

    private static interface Condition {
        public boolean accept(ModelEventType var1);
    }
}

