/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.data;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserver;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.data.Value;
import de.neemann.digital.data.ValueTable;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.components.OrderMerger;
import de.neemann.digital.gui.components.data.GraphDialog;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.parser.TestRow;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ScopeTrigger
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(ScopeTrigger.class, PinInfo.input("T").setClock()).addAttribute(Keys.LABEL).addAttribute(Keys.TRIGGER).addAttribute(Keys.MAX_STEP_COUNT);
    private final int maxSize;
    private final String label;
    private final Trigger trigger;
    private ObservableValue clockValue;
    private boolean lastClock;
    private ValueTable logData;
    private ArrayList<Signal> signals;
    private Model model;
    private GraphDialog graphDialog;
    private boolean wasTrigger;
    private ScopeModelStateObserver scopeModelStateObserver;

    public ScopeTrigger(ElementAttributes attr) {
        this.label = attr.getLabel();
        this.maxSize = attr.get(Keys.MAX_STEP_COUNT);
        this.trigger = attr.get(Keys.TRIGGER);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.clockValue = ((ObservableValue)inputs.get(0)).checkBits(1, this).addObserverToValue(this);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clock = this.clockValue.getBool();
        if (clock != this.lastClock) {
            switch (this.trigger) {
                case rising: {
                    this.wasTrigger = !this.lastClock & clock;
                    break;
                }
                case falling: {
                    this.wasTrigger = this.lastClock & !clock;
                    break;
                }
                default: {
                    this.wasTrigger = true;
                }
            }
        }
        this.lastClock = clock;
    }

    @Override
    public void writeOutputs() throws NodeException {
    }

    @Override
    public ObservableValues getOutputs() throws PinException {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void init(Model model) throws NodeException {
        this.model = model;
        this.scopeModelStateObserver = new ScopeModelStateObserver();
        model.addObserver(this.scopeModelStateObserver, ModelEventType.STEP, new ModelEventType[0]);
    }

    private ValueTable createLogData() {
        this.signals = this.model.getSignalsCopy();
        this.signals.removeIf(signal -> !signal.isShowInGraph());
        JFrame m = this.model.getWindowPosManager().getMainFrame();
        if (m instanceof Main) {
            List<String> ordering = ((Main)m).getCircuitComponent().getCircuit().getMeasurementOrdering();
            new OrderMerger<String, Signal>(ordering){

                @Override
                public boolean equals(Signal a, String b) {
                    return a.getName().equals(b);
                }
            }.order(this.signals);
        }
        ArrayList<String> names = new ArrayList<String>(this.signals.size());
        for (Signal signal2 : this.signals) {
            names.add(signal2.getName());
        }
        return new ValueTable(names).setMaxSize(this.maxSize);
    }

    private final class ScopeModelStateObserver
    implements ModelStateObserver {
        private ScopeModelStateObserver() {
        }

        @Override
        public void handleEvent(ModelEvent event) {
            if (ScopeTrigger.this.wasTrigger && event.getType() == ModelEventType.STEP) {
                if (ScopeTrigger.this.logData == null) {
                    ScopeTrigger.this.logData = ScopeTrigger.this.createLogData();
                }
                Value[] sample = new Value[ScopeTrigger.this.logData.getColumns()];
                for (int i = 0; i < ScopeTrigger.this.logData.getColumns(); ++i) {
                    sample[i] = new Value(((Signal)ScopeTrigger.this.signals.get(i)).getValue());
                }
                ScopeTrigger.this.logData.add(new TestRow(sample));
                ScopeTrigger.this.wasTrigger = false;
                if (ScopeTrigger.this.graphDialog == null || !ScopeTrigger.this.graphDialog.isVisible()) {
                    SwingUtilities.invokeLater(() -> {
                        String title = ScopeTrigger.this.label;
                        if (title.isEmpty()) {
                            title = Lang.get("elem_ScopeTrigger_short", new Object[0]);
                        }
                        ScopeTrigger.this.graphDialog = new GraphDialog(ScopeTrigger.this.model.getWindowPosManager().getMainFrame(), title, ScopeTrigger.this.logData, ScopeTrigger.this.model, false).setColumnInfo(GraphDialog.createColumnsInfo(ScopeTrigger.this.signals));
                        ScopeTrigger.this.graphDialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                ScopeTrigger.this.model.removeObserver(ScopeTrigger.this.scopeModelStateObserver);
                            }
                        });
                        ScopeTrigger.this.graphDialog.setVisible(true);
                        ScopeTrigger.this.model.getWindowPosManager().register("Scope_" + ScopeTrigger.this.label, ScopeTrigger.this.graphDialog);
                    });
                }
            }
        }
    }

    public static enum Trigger {
        rising,
        falling,
        both;

    }
}

