/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.data;

import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.data.DataPlotter;
import de.neemann.digital.data.ValueTable;
import de.neemann.digital.draw.graphics.GraphicSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class GraphComponent
extends JComponent {
    private final DataPlotter plotter;

    GraphComponent(ValueTable dataSet, SyncAccess modelSync) {
        this.plotter = new DataPlotter(dataSet, modelSync);
        this.addMouseWheelListener(e -> {
            double f = Math.pow(0.9, e.getWheelRotation());
            this.scale(f, e.getX());
        });
        this.addMouseMotionListener(new MouseAdapter(){
            private int lastxPos;
            private int lastyPos;

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.lastxPos = mouseEvent.getX();
                this.lastyPos = mouseEvent.getY();
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int xPos = mouseEvent.getX();
                int yPos = mouseEvent.getY();
                GraphComponent.this.plotter.move(xPos - this.lastxPos, yPos - this.lastyPos);
                this.lastxPos = xPos;
                this.lastyPos = yPos;
                GraphComponent.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GraphComponent.this.plotter.setWidth(GraphComponent.this.getWidth());
                GraphComponent.this.plotter.setHeight(GraphComponent.this.getHeight());
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.plotter.drawTo(new GraphicSwing(g2), null);
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.plotter.getCurrentGraphicWidth();
        if (w < 600) {
            w = 600;
        }
        return new Dimension(w, this.plotter.getGraphicHeight());
    }

    public void scale(double f, int xPos) {
        this.plotter.scale(f, xPos);
        this.repaint();
    }

    void fitData() {
        this.plotter.fitInside();
        this.repaint();
    }

    DataPlotter getPlotter() {
        return this.plotter;
    }

    void setHorizontalScrollBar(JScrollBar horizontalScrollBar) {
        this.plotter.setHorizontalScrollBar(horizontalScrollBar);
        horizontalScrollBar.addAdjustmentListener(adjustmentEvent -> {
            if (this.plotter.setNewXOffset(adjustmentEvent.getValue())) {
                this.repaint();
            }
        });
    }

    void setVerticalScrollBar(JScrollBar verticalScrollBar) {
        this.plotter.setVerticalScrollBar(verticalScrollBar);
        verticalScrollBar.addAdjustmentListener(adjustmentEvent -> {
            if (this.plotter.setNewYOffset(adjustmentEvent.getValue())) {
                this.repaint();
            }
        });
    }
}

