/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;

public class WindowPosManager {
    private final Map<String, Window> windows;
    private final JFrame main;
    private boolean shutdown;

    public WindowPosManager(JFrame main) {
        this.main = main;
        this.windows = new HashMap<String, Window>();
    }

    public JFrame getMainFrame() {
        return this.main;
    }

    public <T extends Window> T register(String id, T window) {
        if (this.windows.containsKey(id)) {
            Window oldWindow = this.windows.get(id);
            window.setLocation(oldWindow.getLocation());
            window.setSize(oldWindow.getSize());
            oldWindow.dispose();
        }
        if (this.shutdown) {
            window.dispose();
        } else {
            this.windows.put(id, window);
        }
        return window;
    }

    public void shutdown() {
        this.shutdown = true;
        this.closeAll();
    }

    public void closeAll() {
        for (Window w : this.windows.values()) {
            w.dispose();
        }
    }

    public boolean isVisible(String id) {
        Window w = this.windows.get(id);
        if (w == null) {
            return false;
        }
        return w.isVisible();
    }
}

