/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.rom.ROMInterface;
import de.neemann.digital.core.memory.rom.ROMManagerFile;
import de.neemann.digital.gui.components.AttributeDialog;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ROMEditorDialog
extends JDialog {
    private static final Key.KeyEnum<RomHolder.Source> SOURCE = new Key.KeyEnum("source", (Enum)RomHolder.Source.noData, (Enum[])RomHolder.Source.values());
    private static final Key<DataField> DATA = new Key<DataField>("Data", DataField::new).setDependsOn(SOURCE, source -> source.equals((Object)RomHolder.Source.dataField));
    private static final Key<File> DATA_FILE = new Key.KeyFile("lastDataFile", new File("")).setDependsOn(SOURCE, source -> source.equals((Object)RomHolder.Source.file));
    private static final Key<Boolean> BIG_ENDIAN = new Key<Boolean>("bigEndian", false).setSecondary().setDependsOn(SOURCE, source -> source.equals((Object)RomHolder.Source.file));
    private static final List<Key> KEY_ARRAY_LIST = new ArrayList<Key>();
    private final ROMModel romModel = new ROMModel();
    private boolean ok = false;

    public ROMEditorDialog(JDialog parent, Model model, ROMManagerFile romManager) {
        super(parent, Lang.get("win_romDialog", new Object[0]), true);
        for (Node n2 : model.findNode(n -> n instanceof ROMInterface)) {
            ROMInterface ri = (ROMInterface)((Object)n2);
            String label = ri.getLabel().trim();
            if (label.length() <= 0) continue;
            ROMManagerFile.RomContainer df = romManager.getRomContainer(label);
            this.romModel.add(new RomHolder(ri, df));
        }
        this.romModel.sort();
        final JList<RomHolder> list = new JList<RomHolder>(this.romModel);
        list.setSelectionMode(0);
        this.getContentPane().add(new JScrollPane(list));
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int i = list.getSelectedIndex();
                if (mouseEvent.getClickCount() == 2 && i >= 0 && i < ROMEditorDialog.this.romModel.getSize()) {
                    ROMEditorDialog.this.romModel.edit(i);
                }
            }
        });
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(new ToolTipAction(Lang.get("btn_edit", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = list.getSelectedIndex();
                if (i >= 0 && i < ROMEditorDialog.this.romModel.getSize()) {
                    ROMEditorDialog.this.romModel.edit(i);
                }
            }
        }.setToolTip(Lang.get("btn_editRom_tt", new Object[0])).createJButton());
        buttons.add(new ToolTipAction(Lang.get("btn_clearData", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = list.getSelectedIndex();
                if (i >= 0 && i < ROMEditorDialog.this.romModel.getSize()) {
                    ROMEditorDialog.this.romModel.delete(i);
                }
            }
        }.setToolTip(Lang.get("btn_clearRom_tt", new Object[0])).createJButton());
        this.getContentPane().add((Component)buttons, "East");
        buttons.add(new JButton(new AbstractAction(Lang.get("ok", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                ROMEditorDialog.this.ok = true;
                ROMEditorDialog.this.dispose();
            }
        }));
        this.getContentPane().add((Component)buttons, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.ok;
    }

    public ROMManagerFile getROMManager() {
        return this.romModel.createRomManager();
    }

    static {
        KEY_ARRAY_LIST.add(SOURCE);
        KEY_ARRAY_LIST.add(DATA);
        KEY_ARRAY_LIST.add(DATA_FILE);
        KEY_ARRAY_LIST.add(BIG_ENDIAN);
    }

    private final class ROMModel
    implements ListModel<RomHolder> {
        private final ArrayList<RomHolder> romlist;
        private ArrayList<ListDataListener> listeners = new ArrayList();

        private ROMModel() {
            this.romlist = new ArrayList();
        }

        public void add(RomHolder ri) {
            this.romlist.add(ri);
        }

        @Override
        public int getSize() {
            return this.romlist.size();
        }

        @Override
        public RomHolder getElementAt(int i) {
            return this.romlist.get(i);
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.listeners.add(listDataListener);
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }

        private void sort() {
            this.romlist.sort(Comparator.comparing(r -> ((RomHolder)r).ri.getLabel()));
        }

        public void delete(int i) {
            this.romlist.get(i).source = RomHolder.Source.noData;
            this.fireChanged(i);
        }

        public void edit(int i) {
            RomHolder rh = this.romlist.get(i);
            if (rh.edit(ROMEditorDialog.this)) {
                this.fireChanged(i);
            }
        }

        private void fireChanged(int i) {
            ListDataEvent ev = new ListDataEvent(this, 0, i, i);
            for (ListDataListener l : this.listeners) {
                l.contentsChanged(ev);
            }
        }

        private ROMManagerFile createRomManager() {
            ROMManagerFile rm = new ROMManagerFile();
            for (RomHolder rh : this.romlist) {
                ROMManagerFile.RomContainer romContainer = rh.getRomContainer();
                if (romContainer == null) continue;
                rm.addContainer(rh.ri.getLabel(), romContainer);
            }
            return rm;
        }
    }

    private static final class RomHolder {
        private final ROMInterface ri;
        private boolean bigEndian;
        private Source source;
        private File file;
        private DataField data;

        private RomHolder(ROMInterface ri, ROMManagerFile.RomContainer data) {
            this.ri = ri;
            if (data instanceof ROMManagerFile.RomContainerFile) {
                this.source = Source.file;
                this.data = new DataField(0);
                this.file = ((ROMManagerFile.RomContainerFile)data).getFile();
                this.bigEndian = ((ROMManagerFile.RomContainerFile)data).isBigEndian();
            } else if (data instanceof ROMManagerFile.RomContainerDataField) {
                this.source = Source.dataField;
                this.data = ((ROMManagerFile.RomContainerDataField)data).getDataField(0, null);
                this.file = new File("");
                this.bigEndian = false;
            } else {
                this.source = Source.noData;
                this.data = new DataField(0);
                this.file = new File("");
                this.bigEndian = false;
            }
        }

        public String toString() {
            switch (this.source) {
                case dataField: {
                    return this.ri.getLabel() + " (" + Lang.get("key_source_dataField", new Object[0]) + ")";
                }
                case file: {
                    return this.ri.getLabel() + " (" + this.file + ")";
                }
            }
            return this.ri.getLabel() + " (" + Lang.get("msg_noData", new Object[0]) + ")";
        }

        public boolean edit(ROMEditorDialog romEditorDialog) {
            ElementAttributes attr = new ElementAttributes().set(BIG_ENDIAN, this.bigEndian).set(DATA, this.data).set(SOURCE, this.source).set(Keys.ADDR_BITS, this.ri.getAddrBits()).set(Keys.BITS, this.ri.getDataBits()).set(DATA_FILE, this.file);
            AttributeDialog ad = new AttributeDialog((Window)romEditorDialog, KEY_ARRAY_LIST, attr);
            ElementAttributes mod = ad.showDialog();
            if (mod != null) {
                this.data = (DataField)mod.get(DATA);
                this.data.trim();
                this.file = (File)mod.get(DATA_FILE);
                this.bigEndian = (Boolean)mod.get(BIG_ENDIAN);
                this.source = (Source)((Object)mod.get(SOURCE));
                return true;
            }
            return false;
        }

        public ROMManagerFile.RomContainer getRomContainer() {
            switch (this.source) {
                case file: {
                    return new ROMManagerFile.RomContainerFile(this.file, this.bigEndian);
                }
                case dataField: {
                    return new ROMManagerFile.RomContainerDataField(this.data);
                }
            }
            return null;
        }

        static enum Source {
            noData,
            file,
            dataField;

        }
    }
}

